package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 验票用户可看演出表
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinCheckUserPerformances implements Serializable  ,Cloneable{

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * check_user_performance_id
     */
    private String checkUserPerformanceId;

    /**
     * 演出id
     */
    private String performanceId;

    /**
     * check_user_id
     */
    private String checkUserId;

    /**
     * 状态 1可用 0不可
     */
    private Integer status;

    /**
     * 可下载时间
     */
    private LocalDateTime canDownTime;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;

    private static final KylinCheckUserPerformances obj = new KylinCheckUserPerformances();
    public static KylinCheckUserPerformances getNew() {
        try {
            return (KylinCheckUserPerformances) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinCheckUserPerformances();
        }
    }
}
