package com.liquidnet.service.goblin.service.impl;

import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinNftGoodsSkuInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinNftOrderDetailsVo;
import com.liquidnet.service.goblin.dto.vo.GoblinNftOrderVo;
import com.liquidnet.service.goblin.service.IGoblinNftOrderAppService;
import com.liquidnet.service.goblin.util.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@Slf4j
public class GoblinNftOrderAppServiceImpl implements IGoblinNftOrderAppService {

    @Autowired
    GoblinRedisUtils redisUtils;
    @Autowired
    GoblinMongoUtils mongoUtils;
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    GoblinOrderUtils orderUtils;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;

    @Override
    public ResponseDto<PageInfo<GoblinNftOrderDetailsVo>> orderList(int page) {
        String uid = CurrentUtil.getCurrentUid();
        List<GoblinNftOrderDetailsVo> orderVoList = ObjectUtil.goblinNftOrderDetailsVoArrayList();
        List<String> orderIds;
        orderIds = redisUtils.getNftOrderList(uid);

        int size = 40;
        int finalCount = orderIds.size() - page * size;
        int initCount = orderIds.size() - (page - 1) * size - 1;
        if (finalCount <= 0) {
            finalCount = 0;
        }
        for (int i = initCount; i >= finalCount; i--) {
            String orderId = orderIds.get(i);
            // 订单信息
            GoblinNftOrderVo orderVo = redisUtils.getGoblinNftOrder(orderId);
            GoblinNftOrderDetailsVo orderDetails = GoblinNftOrderDetailsVo.getNew().copy(orderVo);
            // 商品信息
            GoblinGoodsSkuInfoVo goodsSkuInfoVo = goblinRedisUtils.getGoodsSkuInfoVo(orderVo.getSkuId());
            GoblinNftGoodsSkuInfoVo nftGoodsSkuInfoVo = GoblinNftGoodsSkuInfoVo.getNew().copy(goodsSkuInfoVo);
            orderDetails.setGoodsSkuInfoVo(nftGoodsSkuInfoVo);
            // 加入列表
            orderVoList.add(orderDetails);
        }
        PageInfo<GoblinNftOrderDetailsVo> pageInfo = new PageInfo(orderVoList);
        pageInfo.setTotal(orderIds.size());
        return ResponseDto.success(pageInfo);
    }

    @Override
    public ResponseDto<GoblinNftOrderDetailsVo> orderDetails(String orderId) {
        GoblinNftOrderVo orderVo = redisUtils.getGoblinNftOrder(orderId);
        if (null == orderVo) {
            return ResponseDto.failure("订单不存在");
        }

        String uid = CurrentUtil.getCurrentUid();
        if (!orderVo.getUserId().equals(uid)) {
            return ResponseDto.failure(ErrorMapping.get("20003"));
        }
        // 订单信息
        GoblinNftOrderDetailsVo orderDetails = GoblinNftOrderDetailsVo.getNew().copy(orderVo);
        orderDetails.setOrderCode(orderDetails.getOrderCode().substring(orderDetails.getOrderCode().length() - 10));
        // 商品信息
        GoblinGoodsSkuInfoVo goodsSkuInfoVo = goblinRedisUtils.getGoodsSkuInfoVo(orderVo.getSkuId());
        GoblinNftGoodsSkuInfoVo nftGoodsSkuInfoVo = GoblinNftGoodsSkuInfoVo.getNew().copy(goodsSkuInfoVo);
        orderDetails.setGoodsSkuInfoVo(nftGoodsSkuInfoVo);

        return ResponseDto.success(orderDetails);
    }

}
