package com.liquidnet.service.platform.service.impl.adam;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.adam.dto.vo.AdamPosScanitVo;
import com.liquidnet.service.adam.dto.vo.AdamProPerformMarkVo;
import com.liquidnet.service.adam.dto.vo.AdamProScanitVo;
import com.liquidnet.service.adam.dto.vo.AdamUserMemberVo;
import com.liquidnet.service.adam.entity.AdamUser;
import com.liquidnet.service.adam.entity.AdamUserInfo;
import com.liquidnet.service.adam.entity.AdamUserMember;
import com.liquidnet.service.adam.mapper.AdamUserInfoMapper;
import com.liquidnet.service.adam.mapper.AdamUserMapper;
import com.liquidnet.service.adam.mapper.AdamUserMemberMapper;
import com.liquidnet.service.platform.utils.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;

@Service
public class PlatformAdamUserPosService extends ServiceImpl<AdamUserInfoMapper, AdamUserInfo> {
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;
    @Autowired
    private AdamUserMemberMapper adamUserMemberMapper;
    @Autowired
    private AdamUserMapper adamUserMapper;

    public AdamPosScanitVo scanitProcess(String code) {
        LambdaQueryWrapper<AdamUserInfo> userInfoLambdaQueryWrapper = Wrappers.lambdaQuery(AdamUserInfo.class);
        userInfoLambdaQueryWrapper.eq(AdamUserInfo::getQrCode, code);

        userInfoLambdaQueryWrapper.select(AdamUserInfo::getUid, AdamUserInfo::getNickname);
        AdamUserInfo userInfo = this.getOne(userInfoLambdaQueryWrapper);

        AdamPosScanitVo scanitVo = AdamPosScanitVo.getNew();
        if (null != userInfo) {
            LambdaQueryWrapper<AdamUser> adamUserLambdaQueryWrapper = Wrappers.lambdaQuery(AdamUser.class);
            adamUserLambdaQueryWrapper.eq(AdamUser::getUid, userInfo.getUid());
            adamUserLambdaQueryWrapper.eq(AdamUser::getState, 1);

            adamUserLambdaQueryWrapper.select(AdamUser::getUid, AdamUser::getMobile);
            AdamUser user = adamUserMapper.selectOne(adamUserLambdaQueryWrapper);

            scanitVo.setNickname(userInfo.getNickname());
            scanitVo.setMobile(user.getMobile());
            scanitVo.setUid(user.getUid());

            LambdaQueryWrapper<AdamUserMember> userMemberLambdaQueryWrapper = Wrappers.lambdaQuery(AdamUserMember.class);
            userMemberLambdaQueryWrapper.eq(AdamUserMember::getUid, userInfo.getUid());
            userMemberLambdaQueryWrapper.eq(AdamUserMember::getState, 1);

            userMemberLambdaQueryWrapper.select(AdamUserMember::getUid,
                    AdamUserMember::getState,
                    AdamUserMember::getExpiryAt,
                    AdamUserMember::getCreatedAt,
                    AdamUserMember::getUpdatedAt
            );
            AdamUserMember userMember = adamUserMemberMapper.selectOne(userMemberLambdaQueryWrapper);
            if (null == userMember) {
                scanitVo.setStageMarker(0);
            } else {
                AdamUserMemberVo userMemberVo = AdamUserMemberVo.getNew().copy(userMember);
                if (userMemberVo.isActive()) {
                    scanitVo.setStageMarker(userMemberVo.isOldMember() ? 10 : 11);
                } else {
                    scanitVo.setStageMarker(2);
                }
            }
        }

        return scanitVo;
    }
}
