package com.liquidnet.service.bank.currencycloud.controller;

import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.common.BankResultDto;
import com.liquidnet.service.bank.config.swagger.BankSwaggerApiVersionConstant;
import com.liquidnet.service.bank.currencycloud.dto.BankCcConversionDatesDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcConversionDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcConversionCreateParam;
import com.liquidnet.service.bank.currencycloud.service.IBankCcConversionService;
import com.liquidnet.service.bank.currencycloud.service.IBankCcReferenceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * <p>
 * 下发表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-13
 */
@Api(tags = "conversion")
@Slf4j
@RestController
@RequestMapping("/bank-cc-conversion")
public class BankCcConversionController {

    @Autowired
    private IBankCcConversionService bankCcConversionService;

    @Autowired
    private IBankCcReferenceService bankCcReferenceService;

    @SwaggerApiVersion(group = BankSwaggerApiVersionConstant.API_CC)
    @ApiOperation(value = "cc create conversion")
    @PostMapping(value = "/create")
    public ResponseDto<BankCcConversionDto> createConversion(@RequestBody BankCcConversionCreateParam param) {
        BankResultDto<BankCcConversionDto> resultDto = bankCcConversionService.createConversions(param);
        return BankResultDto.getResponseDto(resultDto);
    }

    @SwaggerApiVersion(group = BankSwaggerApiVersionConstant.API_CC)
    @ApiOperation(value = "get conversion dates")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "query", dataType = "String", name = "conversionPair"),
            @ApiImplicitParam(paramType = "query", dataType = "String", name = "startDate"),
    })
    @GetMapping(value = "/get_conversion_dates")
    public ResponseDto<BankCcConversionDatesDto> getConversionDates(
            @RequestParam String conversionPair,
            @RequestParam(required = false) String startDate) throws ParseException {

        Date st = null;
        if (!StringUtils.isEmpty(startDate)) {
            DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            st = dateFormat.parse(startDate);
        }
        return bankCcReferenceService.getConversionDates(conversionPair, st);
    }

}
