package com.liquidnet.client.admin.web.controller.zhengzai.goblin;


import com.alibaba.fastjson.JSON;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.goblin.service.impl.GoblinFrontHotWordServiceImpl;
import com.liquidnet.service.goblin.entity.GoblinFrontHotWord;
import com.liquidnet.service.goblin.param.GoblinFrontHotWordBuildParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 热词
 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-28
 */
@Api(tags = "热词管理")
@RestController
@RequestMapping("/hotWord")
public class GoblinFrontHotWordController extends BaseController {
    @Autowired
    GoblinFrontHotWordServiceImpl goblinFrontHotWordService;
    /**
     * @author zhangfuxin
     * @Description:添加banner
     * @date 2021/12/27 下午1:22
     */
    @PostMapping("create")
    @ApiOperation(value = "增加热词")
    @ResponseBody
    public AjaxResult create(@RequestBody GoblinFrontHotWordBuildParam goblinFrontHotWordBuildParam) {
        GoblinFrontHotWord goblinFrontHotWord=new GoblinFrontHotWord();
        BeanUtils.copyProperties(goblinFrontHotWordBuildParam,goblinFrontHotWord);
        logger.info("增加热词{}", JSON.toJSONString(goblinFrontHotWord));
        boolean result=goblinFrontHotWordService.create(goblinFrontHotWord);
        if (result ) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }
    @PostMapping("updateOrCreate")
    @ApiOperation(value = "修改或者增加热词")
    @ResponseBody
    public AjaxResult updateOrCreate(@RequestBody GoblinFrontHotWordBuildParam goblinFrontHotWordBuildParam) {
        GoblinFrontHotWord goblinFrontHotWord=new GoblinFrontHotWord();
        BeanUtils.copyProperties(goblinFrontHotWordBuildParam,goblinFrontHotWord);
        logger.info("修改热词{}", JSON.toJSONString(goblinFrontHotWord));
        boolean result=goblinFrontHotWordService.update(goblinFrontHotWord);
        if (result ) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }
    @PostMapping("list")
    @ApiOperation(value = "list")
    @ResponseBody
    public AjaxResult page( ) {
        return AjaxResult.success(goblinFrontHotWordService.list());
    }

    @PostMapping("delete")
    @ApiOperation(value = "删除热词")
    @ResponseBody
    public AjaxResult delete( @RequestBody  GoblinFrontHotWordBuildParam goblinFrontHotWordBuildParam) {
        GoblinFrontHotWord goblinFrontHotWord=new GoblinFrontHotWord();
        BeanUtils.copyProperties(goblinFrontHotWordBuildParam,goblinFrontHotWord);
        logger.info("删除热词{}", JSON.toJSONString(goblinFrontHotWord));
        boolean result=goblinFrontHotWordService.delete(goblinFrontHotWord.getMid());
        if (result ) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }
    @PostMapping("getOne")
    @ApiOperation(value = "查看详情")
    @ResponseBody
    public AjaxResult getOne( @RequestBody GoblinFrontHotWordBuildParam goblinFrontHotWordBuildParam) {
        GoblinFrontHotWord goblinFrontHotWord=new GoblinFrontHotWord();
        BeanUtils.copyProperties(goblinFrontHotWordBuildParam,goblinFrontHotWord);
        logger.info("查看详情{}", JSON.toJSONString(goblinFrontHotWord));
        goblinFrontHotWord=goblinFrontHotWordService.getOne(goblinFrontHotWord.getMid());
        return AjaxResult.success(goblinFrontHotWord);
    }
    @PostMapping("page")
    @ApiOperation(value = "分页")
    @ResponseBody
    public AjaxResult page( @RequestParam(name = "pageSize", required = true) int pageSize,@RequestParam(name = "pageNumber", required = true)int pageNumber,@RequestBody GoblinFrontHotWordBuildParam goblinFrontHotWordBuildParam) {
        GoblinFrontHotWord goblinFrontHotWord=new GoblinFrontHotWord();
        BeanUtils.copyProperties(goblinFrontHotWordBuildParam,goblinFrontHotWord);
        logger.info("分页banner{}", JSON.toJSONString(goblinFrontHotWord));
        return AjaxResult.success(goblinFrontHotWordService.page(pageSize,pageNumber,null));
    }
}
