package com.liquidnet.service.goblin.controller.manage;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateAddParam;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateParam;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateUpdateParam;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateValueParam;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsAnticipateVo;
import com.liquidnet.service.goblin.service.IGoblinGoodsAnticipateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 预约表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-07
 */
@Slf4j
@RestController
@Api(tags = "预约相关")
@RequestMapping("/goblin/anticipate")
public class GoblinGoodsAnticipateController {

    @Autowired
    IGoblinGoodsAnticipateService goblinGoodsAnticipateService;

    @ApiOperation("创建预约信息")
    @PostMapping("/add")
    public ResponseDto<Object> add(@RequestBody GoblinGoodsAnticipateAddParam goodsAnticipateAddParam) {
        return goblinGoodsAnticipateService.add(goodsAnticipateAddParam);
    }

    @PostMapping("/list")
    @ApiOperation("获取预约列表")
    public ResponseDto<PageInfo<GoblinGoodsAnticipateVo>> list(GoblinGoodsAnticipateParam goodsAnticipateParam) {
        return goblinGoodsAnticipateService.list(goodsAnticipateParam);
    }


    @ApiOperation("修改预约人数")
    @PostMapping("/updatePeople")
    public ResponseDto<Object> updatePeople(@RequestParam(name = "antId", required = true) String antId, @RequestParam(name = "people", required = true) Long people) {
        return goblinGoodsAnticipateService.updatePeople(antId, people);
    }

    @ApiOperation("修改预约")
    @PostMapping("/update")
    public ResponseDto<Object> update(GoblinGoodsAnticipateUpdateParam goodsAnticipateUpdateParam) {
        return goblinGoodsAnticipateService.update(goodsAnticipateUpdateParam);
    }

    @ApiOperation("删除预约")
    @DeleteMapping("/delete")
    public ResponseDto<Object> delete(@RequestParam(name = "antId") String antId) {
        return goblinGoodsAnticipateService.delete(antId);
    }

    @ApiOperation("创建预约关联sku")
    @PostMapping("/addAnticipateValues")
    public ResponseDto<Object> addAnticipateValues(List<GoblinGoodsAnticipateValueParam> list) {
        return goblinGoodsAnticipateService.addAnticipateValues(list);
    }

    @ApiOperation("修改预约关联")
    @PostMapping("/updateAnticipateValues")
    public ResponseDto<Object> updateAnticipateValues(List<GoblinGoodsAnticipateValueParam> list ) {
        return goblinGoodsAnticipateService.updateAnticipateValues(list);
    }


    @ApiOperation("用户预约（state预约标识：0为预约，1为取消预约）")
    @PostMapping("/userAbout")
    public ResponseDto<Object> userAbout(@RequestParam(name = "antId", required = true) String antId,
                                         @RequestParam(name = "skuId", required = true) String skuId,
                                         @RequestParam(name = "uid", required = true) String uid,
                                         @RequestParam(name = "phone", required = true) String phone,
                                         @RequestParam(name = "state", required = true) Integer state) {
        return goblinGoodsAnticipateService.userAbout(antId, skuId, uid, phone, state);
    }

    @ApiOperation("根据spuId查询出所有的sku")
    @PostMapping("")
    public ResponseDto<Object> getSkus(@RequestParam(name = "apuId") String SpuId) {
        return goblinGoodsAnticipateService.getSkus(SpuId);
    }
}
