package com.liquidnet.service.merchant.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.merchant.dto.param.MerchantSponsorApplyParam;
import com.liquidnet.service.merchant.dto.vo.MerchantSponsorsVo;
import com.liquidnet.service.merchant.dto.vo.MerchantSponsorAppliesVo;
import com.liquidnet.service.merchant.service.IMerchantSponsorAppliesService;
import com.liquidnet.service.merchant.service.IMerchantSponsorsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * <p>
 * 主办 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-11-01
 */
@ApiSupport(order = 10002)
@Api(tags = "主办")
@Slf4j
@Validated
@RestController
@RequestMapping("sponsors")
public class MerchantSponsorsController {

    @Autowired
    IMerchantSponsorsService merchantSponsorsService;

    @Autowired
    IMerchantSponsorAppliesService merchantSponsorAppliesService;

    @ApiOperationSupport(order = 10)
    @ApiOperation(value = "主办搜索")
    @GetMapping("search")
    public ResponseDto<PagedResult<MerchantSponsorsVo>> search(@RequestParam(required = true) String name,
                                                             @RequestParam(defaultValue = "1", required = false) int page,
                                                             @RequestParam(defaultValue = "10", required = false) int size) {
        return ResponseDto.success(merchantSponsorsService.search(name, page, size));
    }

    @ApiOperationSupport(order = 11)
    @ApiOperation(value = "申请主办")
    @PostMapping("apply")
    public ResponseDto<Object> apply(@Valid @RequestBody MerchantSponsorApplyParam parameter) {
        String currentUid = CurrentUtil.getCurrentUid();

        return ResponseDto.success(merchantSponsorAppliesService.apply(currentUid, parameter));
    }

    @ApiOperationSupport(order = 12)
    @ApiOperation(value = "申请主办驳回后删除")
    @PostMapping("apply/del")
    public ResponseDto<Object> applyDel(@RequestParam(required = true) String sponsorApplyId) {
        String currentUid = CurrentUtil.getCurrentUid();

        merchantSponsorAppliesService.applyDel(currentUid, sponsorApplyId);

        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 13)
    @ApiOperation(value = "申请主办详情")
    @PostMapping("apply/info")
    public ResponseDto<MerchantSponsorAppliesVo> applyInfo(@RequestParam(required = true) String sponsorApplyId) {
        String currentUid = CurrentUtil.getCurrentUid();

        return ResponseDto.success(merchantSponsorAppliesService.applyInfo(currentUid, sponsorApplyId));
    }

    @ApiOperationSupport(order = 20)
    @ApiOperation(value = "主办详情")
    @GetMapping("info")
    public ResponseDto<MerchantSponsorsVo> info(@RequestParam(required = true) String sponsorId) {
        String currentUid = CurrentUtil.getCurrentUid();

        return ResponseDto.success(merchantSponsorsService.sponsorInfo(currentUid, sponsorId));
    }
}
