package com.liquidnet.service.erp.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 同步库存用 vo 和 erp无关，关联业务
 */
@Data
public class SyncStockVo implements Serializable, Cloneable {
    // erp sku编码
    private String specNo;
    // erp sku库存
    private BigDecimal stockErpNum;
    // 自研商城 sku库存
    private BigDecimal stockNum;
    // erp sku所属仓库编码
    private String warehouseNo;

    private static final SyncStockVo obj = new SyncStockVo();

    public static SyncStockVo getNew() {
        try {
            return (SyncStockVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SyncStockVo();
        }
    }

}
