package com.liquidnet.service.sweet.controller;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetManualNotify;
import com.liquidnet.service.sweet.entity.SweetManualShop;
import com.liquidnet.service.sweet.service.ISweetManualNotifyService;
import com.liquidnet.service.sweet.service.ISweetManualShopService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 电子宣传手册商铺表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-29
 */
@RestController
@Api(tags = "电子手册吃喝玩乐")
@RequestMapping("/sweet-manual-shop")
public class SweetManualShopController {

    @Autowired
    ISweetManualShopService sweetManualShopService;

    @GetMapping("list")
    @ApiOperation("列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "类型 1吃喝 2玩乐", required = true),
    })
    public ResponseDto<List<SweetManualShop>> getList(@RequestParam String manualId,
                                                      @RequestParam Integer type) {
        return sweetManualShopService.getList(manualId, type);
    }

    @GetMapping("details")
    @ApiOperation("详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualShopId", value = "商铺id", required = true),
    })
    public ResponseDto<SweetManualShop> details(@RequestParam String manualShopId) {
        return sweetManualShopService.details(manualShopId);
    }

    @PostMapping("add")
    @ApiOperation("添加")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "手册iid", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "title", value = "标题", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "picUrl", value = "图片地址", required = false),
            @ApiImplicitParam(type = "query", dataType = "String", name = "describes", value = "描述", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "类型 1吃喝 2玩乐", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isRecommend", value = "是否推荐", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "sort", value = "排序", required = true),
    })
    public ResponseDto<Boolean> add(@RequestParam String manualId,
                                    @RequestParam String title,
                                    @RequestParam String picUrl,
                                    @RequestParam String describes,
                                    @RequestParam Integer type,
                                    @RequestParam Integer isRecommend,
                                    @RequestParam Integer sort) {
        return sweetManualShopService.add(manualId, title, picUrl, describes, type, isRecommend, sort);
    }

    @PostMapping("change")
    @ApiOperation("修改")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualShopId", value = "商铺id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "title", value = "标题", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "picUrl", value = "图片地址", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "describes", value = "描述", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "类型 1吃喝 2玩乐", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isRecommend", value = "是否推荐", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "sort", value = "排序", required = true),
    })
    public ResponseDto<Boolean> change(@RequestParam String manualShopId,
                                       @RequestParam String manualId,
                                       @RequestParam String title,
                                       @RequestParam String picUrl,
                                       @RequestParam String describes,
                                       @RequestParam Integer type,
                                       @RequestParam Integer isRecommend,
                                       @RequestParam Integer sort) {
        return sweetManualShopService.change(manualShopId, manualId, title, picUrl, describes, type, isRecommend, sort);
    }


    @DeleteMapping("delete")
    @ApiOperation("删除")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualShopId", value = "商铺id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "手册id", required = true),
    })
    public ResponseDto<Boolean> delete(@RequestParam() String manualShopId,
                                       @RequestParam String manualId) {
        return sweetManualShopService.delete(manualShopId, manualId);
    }
}
