package com.liquidnet.service.kylin.dao;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 跟活动绑定的券
 * </p>
 *
 * @author liquidnet
 * @since 2022-07-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinTicketActive implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 票id
     */
    private String ticketId;

    /**
     * 兑换码
     */
    private String code;

    /**
     * 兑换码状态 1未兑换 2已兑换 3已失效
     */
    private Integer state;

    /**
     * 兑换用户id
     */
    private String redeemUid;

    /**
     * 兑换时间
     */
    private LocalDateTime redeemAt;

    /**
     * 活动id
     */
    private String activityId;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    /**
     * 0未删除1已删除
     */
    private Integer delTag;


}
