package com.liquidnet.service.stone.service.impl;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoSimpleVo;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.stone.dto.StoneScoreListDto;
import com.liquidnet.service.stone.service.IStoneScoreUserService;
import com.liquidnet.service.stone.util.InnerUtils;
import com.liquidnet.service.stone.util.QueueUtils;
import com.liquidnet.service.stone.util.StoneMongoUtils;
import com.liquidnet.service.stone.util.StoneRedisUtils;
import com.liquidnet.service.stone.vo.StoneTaskVo;
import com.liquidnet.service.stone.vo.StoneUserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 积分用户表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-10-19
 */
@Service
public class StoneScoreUserServiceImpl implements IStoneScoreUserService {

    @Autowired
    StoneRedisUtils redisUtils;
    @Autowired
    StoneMongoUtils mongoUtils;
    @Autowired
    QueueUtils queueUtils;

    @Override
    public StoneScoreListDto stoneUserInfo() {
        try {
            String uid = CurrentUtil.getCurrentUid();
            StoneScoreListDto vo = StoneScoreListDto.getNew();
            AdamUserInfoSimpleVo userVo = InnerUtils.getUserInfo();
            StoneUserVo userTaskVo = redisUtils.getUserData(uid);
            if (userTaskVo == null) {
                userTaskVo = StoneUserVo.getNew();
                userTaskVo.getTask();
                userTaskVo.setUid(uid);
                userTaskVo.setStatus(1);
                //redis
                redisUtils.setUserData(uid, userTaskVo);
                //mongo
                mongoUtils.userCreate(userTaskVo);
                //mysql 创建用户积分表数据
                queueUtils.sendMsgByRedis(MQConst.StoneQueue.STONE_INSERT_USER.getKey(),
                        SqlMapping.get("stone_score_user.insert", IDGenerator.nextTimeId2(), userTaskVo.getUid(), userTaskVo.getStatus(), LocalDateTime.now())
                );
            }
            int rest = redisUtils.getUserScoreRest(uid);
            int use = redisUtils.getUserScoreUse(uid);
            vo.setAvatar(userVo.getAvatar());
            vo.setMobile(userVo.getMobile());
            vo.setNickName(userVo.getNickname());
            vo.setScoreAll(BigDecimal.valueOf(use + rest));
            vo.setScoreRest(BigDecimal.valueOf(rest));
            vo.setScoreUse(BigDecimal.valueOf(use));
            vo.setStatus(userTaskVo.getStatus());
            vo.setSignIn(0);
            for (StoneTaskVo taskVo : userTaskVo.getTask()) {
                if (taskVo.getTaskId().equals(0)) {
                    if (taskVo.getTaskTime().equals(DateUtil.getNowTime(DateUtil.DATE_SMALL_STR))) {
                        vo.setSignIn(1);
                    }
                }
            }
            return vo;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}
