package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinRefundPerformancesAdminServiceImpl;
import com.liquidnet.service.kylin.dao.OrderRefundBatchDao;
import com.liquidnet.service.kylin.dto.param.RefundApplyParam;
import com.liquidnet.service.kylin.dto.param.RefundBatchApplyParam;
import com.liquidnet.service.kylin.dto.param.RefundBatchSearchParam;
import com.liquidnet.service.kylin.dto.vo.KylinOrderRefundBatchesVo;
import com.liquidnet.service.kylin.dto.vo.OrderDetailsVo;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 后台按演出批量退款 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-25 11:07 上午
 */

@Controller
@RequestMapping("/kylin/refundBatch")
public class KylinOrderRefundBatchAdminController extends BaseController {

    private String prefix = "zhengzai/kylin/refundBatch";

    @Autowired
    private KylinRefundPerformancesAdminServiceImpl kylinRefundPerformancesAdminServiceImpl;

    @RequiresPermissions("kylin:refundBatch:view")
    @GetMapping()
    public String operlog()
    {
        return prefix + "/refundBatch";
    }

    @RequiresPermissions("kylin:refundBatch:detail")
    @GetMapping(value = "/details/{refundBatchId}")
    public String detail(@PathVariable("refundBatchId") String refundBatchId, ModelMap mmap) {
        KylinOrderRefundBatchesVo result = null;
        result = kylinRefundPerformancesAdminServiceImpl.detail(refundBatchId);
        mmap.put("KylinOrderRefundsBatchVo", result);
        return prefix + "/details";
    }

    @RequiresPermissions("kylin:refundBatch:list")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo refundList(RefundBatchSearchParam refundBatchSearchParam) {
        PageInfo<OrderRefundBatchDao> result = kylinRefundPerformancesAdminServiceImpl.refundList(refundBatchSearchParam);
        return getDataTable(result.getList());
    }

    @GetMapping("applyView")
    public String applyView() {
        return prefix +  "/applyView";
    }

    @PostMapping("applyPerformance")
    @ResponseBody
    public String applyPerformance(RefundBatchSearchParam refundBatchSearchParam) {
        return "error";
    }

    @RequiresPermissions("kylin:refundBatch:apply")
    @PostMapping("apply")
    @ResponseBody
    public AjaxResult refundBatchApply(RefundBatchApplyParam refundBatchApplyParam) {
        try {
            Boolean res = kylinRefundPerformancesAdminServiceImpl.refundBatchApply(refundBatchApplyParam);
            if (res) {
                return success();
            } else {
                return error("申请退款失败");
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    @RequiresPermissions("kylin:refundBatch:reapply")
    @PostMapping("reapply")
    @ResponseBody
    public AjaxResult refundBatchReApply(RefundBatchApplyParam refundBatchApplyParam) {
        String ids = refundBatchApplyParam.getIds();
        refundBatchApplyParam.setRefundBatchId(ids);
        try {
            Boolean res = kylinRefundPerformancesAdminServiceImpl.refundBatchReapply(refundBatchApplyParam);
            if (res) {
                return success();
            } else {
                // 不是重新发起退款，而是重新发起退款审核
                return error("再次发起退款审核失败");
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    @RequiresPermissions("kylin:refundBatch:cancel")
    @PostMapping("cancel")
    @ResponseBody
    public AjaxResult refundBatchCancel(RefundBatchApplyParam refundBatchApplyParam) {
        String ids = refundBatchApplyParam.getIds();
        refundBatchApplyParam.setRefundBatchId(ids);
        try {
            Boolean res = kylinRefundPerformancesAdminServiceImpl.refundBatchCancel(refundBatchApplyParam);
            if (res) {
                return success();
            } else {
                return error("取消退款失败");
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    @RequiresPermissions("kylin:refundBatch:review")
    @PostMapping("review")
    @ResponseBody
    public AjaxResult refundBatchReview(RefundBatchApplyParam refundBatchApplyParam) {
        try {
            Boolean res = kylinRefundPerformancesAdminServiceImpl.refundBatchReview(refundBatchApplyParam);
            if (res) {
                return success();
            } else {
                return error("审核退款失败");
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    @RequiresPermissions("kylin:refundBatch:execute")
    @PostMapping("execute")
    @ResponseBody
    public AjaxResult refundBatchExecute(RefundBatchApplyParam refundBatchApplyParam) {
        try {
            Boolean res = kylinRefundPerformancesAdminServiceImpl.refundBatchExecute(refundBatchApplyParam);
            if (res) {
                return success();
            } else {
                return error("审核退款失败");
            }
        } catch (Exception e) {
            e.printStackTrace();
            return error(e.getMessage());
        }
    }

}
