package com.liquidnet.client.admin.zhengzai.adam.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.liquidnet.client.admin.zhengzai.adam.mapper.AdamUserMapper;
import com.liquidnet.client.admin.zhengzai.adam.domain.AdamUser;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamUserService;
import com.liquidnet.client.admin.common.core.text.Convert;

/**
 * 用户Service业务层处理
 * 
 * @author ruoyi
 * @date 2021-05-24
 */
@Service
public class AdamUserServiceImpl implements IAdamUserService 
{
    @Autowired
    private AdamUserMapper adamUserMapper;

    /**
     * 查询用户
     * 
     * @param mid 用户ID
     * @return 用户
     */
    @Override
    public AdamUser selectAdamUserById(Integer mid)
    {
        return adamUserMapper.selectAdamUserById(mid);
    }

    /**
     * 查询用户列表
     * 
     * @param adamUser 用户
     * @return 用户
     */
    @Override
    public List<AdamUser> selectAdamUserList(AdamUser adamUser)
    {
        return adamUserMapper.selectAdamUserList(adamUser);
    }

    /**
     * 新增用户
     * 
     * @param adamUser 用户
     * @return 结果
     */
    @Override
    public int insertAdamUser(AdamUser adamUser)
    {
        return adamUserMapper.insertAdamUser(adamUser);
    }

    /**
     * 修改用户
     * 
     * @param adamUser 用户
     * @return 结果
     */
    @Override
    public int updateAdamUser(AdamUser adamUser)
    {
        return adamUserMapper.updateAdamUser(adamUser);
    }

    /**
     * 删除用户对象
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deleteAdamUserByIds(String ids)
    {
        return adamUserMapper.deleteAdamUserByIds(Convert.toStrArray(ids));
    }

    /**
     * 删除用户信息
     * 
     * @param mid 用户ID
     * @return 结果
     */
    @Override
    public int deleteAdamUserById(Integer mid)
    {
        return adamUserMapper.deleteAdamUserById(mid);
    }
}
