package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;

@ApiModel(value = "AdamMemberOrderCallbackParam", description = "购买会员或会员码的支付回调")
@Data
public class AdamMemberOrderCallbackParam implements Serializable, Cloneable {
    private static final long serialVersionUID = -4161563334263071103L;
    private Integer status;
    private String orderCode;
    private String code;
    private String type;
    private BigDecimal price;
    private String paymentType;
    private String paymentAt;
    private String paymentId;

    private static final AdamMemberOrderCallbackParam obj = new AdamMemberOrderCallbackParam();

    public static AdamMemberOrderCallbackParam getNew() {
        try {
            return (AdamMemberOrderCallbackParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamMemberOrderCallbackParam();
        }
    }

    public AdamMemberOrderCallbackParam get(Map mapParameter) {
        this.setStatus((Integer) mapParameter.get("status"));
        this.setType((String) mapParameter.get("type"));
        this.setCode((String) mapParameter.get("code"));
        this.setOrderCode((String) mapParameter.get("order_code"));
        this.setPrice((BigDecimal) mapParameter.get("price"));
        this.setPaymentType((String) mapParameter.get("payment_type"));
        this.setPaymentAt((String) mapParameter.get("payment_at"));
        this.setPaymentId((String) mapParameter.get("payment_id"));
        return this;
    }
}
