package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamCollectVo", description = "收藏信息")
@Data
public class AdamCollectVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 3222644230886542725L;
    @ApiModelProperty(position = 11, required = true, value = "内容ID[64]")
    private String contentId;
    @ApiModelProperty(position = 12, required = true, value = "内容类型")
    private String type;
    @ApiModelProperty(position = 13, required = true, value = "收藏时间")
    private String createdAt;
    @ApiModelProperty(position = 14, required = true, value = "展示信息")
    private AdamCollectInfoVo contentInfo;

    private static final AdamCollectVo obj = new AdamCollectVo();

    public static AdamCollectVo getNew() {
        try {
            return (AdamCollectVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamCollectVo();
        }
    }
}
