package com.liquidnet.service.constant;

import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.liquidnet.commons.lang.util.JsonUtils;


/**
 * 触发行为
 * @author Administrator
 *
 */
public enum TriggerTypeEnum {
	CREDIT_SUCCESS("1001","信审成功"),
	CREDIT_FAIL("1002","信审失败"),
	LEND_SUCCESS("2001","借款成功"),
	LEND_FAIL("2002","借款失败"),
	LOAN_SUCCESS("3001","放款成功"),
	LOAN_FAIL("3002","放款失败"),
	WITHDRAWALS_SUCCESS("4001","提现成功"),
	WITHDRAWALS_FAIL("4002","提现失败"),
	RECHARGE_SUCCESS("5001","充值成功"),
	RECHARGE_FAIL("5002","充值失败"),
	//批量自动划扣  // 60（还款），1（划扣方式手动） 1（账户类型余额户） （0 ||1 是否全部） 0||1（划扣）
	REPAYMENT_BATCH_ACCOUNT_SUCCESS("602111","批量账户划扣成功"),
	REPAYMENT_BATCH_PART_ACCOUNT_SUCCESS("602101","批量账户部分划扣成功"),
	REPAYMENT_BATCH_BANK_SUCCESS("602211","批量银行卡划扣成功"),
	REPAYMENT_BATCH_ACCOUNT_FAIL("602110","批量账户划扣失败"),
	REPAYMENT_BATCH_PART_ACCOUNT_FAIL("602100","批量账户部分划扣失败"),
	REPAYMENT_BATCH_BANK_FAIL("602210","批量银行卡划扣失败"),
	REPAYMENT_BATCH_BANK3_SUCCESS("602311","批量银行卡划扣成功"),
	REPAYMENT_BATCH_BANK3_FAIL("602310","批量银行卡划扣失败"),
	// 催收- 划扣
	REPAYMENT_COLLECTION_ACCOUNT_SUCCESS("603111","催收账户划扣成功"),
	REPAYMENT_COLLECTION_PART_ACCOUNT_SUCCESS("603101","催收账户部分划扣成功"),
	REPAYMENT_COLLECTION_ACCOUNT_FAIL("603110","催收账户划扣失败"),
	REPAYMENT_COLLECTION_PART_ACCOUNT_FAIL("603100","催收账户部分划扣失败"),
	REPAYMENT_COLLECTION_BANK_SUCCESS("603211","催收银行卡划扣成功"),
	REPAYMENT_COLLECTION__BANK_FAIL("603210","催收银行卡划扣失败"),
	REPAYMENT_COLLECTION_BANK3_SUCCESS("603311","催收银行卡划扣成功"),
	REPAYMENT_COLLECTION__BANK3_FAIL("603310","催收银行卡划扣失败"),
	// 用户主动还款
	REPAYMENT_USER_ACCOUNT_SUCCESS("601111","主动账户划扣成功"),
	REPAYMENT_USER_ACCOUNT_FAIL("601110","主动账户划扣失败"),
	REPAYMENT_USER_PART_ACCOUNT_SUCCESS("601101","主动账户部分划扣成功"),
	REPAYMENT_USER_PART_ACCOUNT_FAIL("601100","主动账户部分划扣失败"),
	REPAYMENT_USER_BANK_SUCCESS("601211","主动银行卡划扣成功"),
	REPAYMENT_USER__BANK_FAIL("601210","主动银行卡划扣失败"),
	//银行卡副卡划扣
	REPAYMENT_USER_BANK3_SUCCESS("601311","主动银行卡划扣成功"),
	REPAYMENT_USER__BANK3_FAIL("601310","主动银行卡划扣失败"),
	REPAYMENT_OVERDUE("6003","还款逾期"),
	TE_SUCCESS("7001","提额成功"),
	TE_FAIL("7002","提额失败"),
	ADDBANKCARD_SUCCESS("8001","添加新卡"),
	CHANGEBANKCARD_SUCCESS("8003","变更主卡成功"),
//	ADDBANKCARD_FAIL("8002","变更主卡失败"),
//	CHANGEBANKCARD_FAIL("8004","变更主卡失败"),
	REPAYMENTDAY_THREE("9003","还款日前三天"),
	REPAYMENTDAY_TWO("9002","还款日前两天"),
	REPAYMENTDAY_ONE("9001","还款日前一天"),
	REPAYMENTDAY_ZERO("9000","还款日当天"),
	COUPON_NOTICE_THREE("10003","道具到期提醒"),
	COUPON_NOTICE_TWO("10002","道具到期提醒"),
	COUPON_NOTICE_ONE("10001","道具到期提醒"),
	COUPON_NOTICE_ZERO("10000","道具到期提醒"),


	CREDIT_SUCCESS_T("100100","信审成功T日提醒"),
	LOAN_SUCCESS_T("300100","放款成功T日提醒"),


	;
	private String code;
	private String msg;

	private TriggerTypeEnum(String code,String msg){
		this.code=code;
		this.msg=msg;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}
	public static String getMsg(String code){
		TriggerTypeEnum[] enums=TriggerTypeEnum.values();
		if(StringUtils.isEmpty(code)){
			return null;
		}
		for(TriggerTypeEnum e:enums){
			if(e.code.equals(code)){
				return e.msg;
			}
		}
		return null;
	}
	public static TriggerTypeEnum getEnum(String code){
		TriggerTypeEnum[] enums=TriggerTypeEnum.values();
		if(StringUtils.isEmpty(code)){
			return null;
		}
		for(TriggerTypeEnum e:enums){
			if(e.code.equals(code)){
				return e;
			}
		}
		return null;
	}

	public static String triggerType(){
		TriggerTypeEnum[] enums=TriggerTypeEnum.values();
		Map<String,String> map=new LinkedHashMap<String,String>();
		for(TriggerTypeEnum e:enums){
			map.put(e.code, e.msg);
		}
		return JsonUtils.toJson(map);

	}
	public static void main(String[] args) {
		TriggerTypeEnum[] enums=TriggerTypeEnum.values();
		Map<String,String> map=new LinkedHashMap<String,String>();
		for(TriggerTypeEnum e:enums){
			map.put(e.code, e.msg);
		}
		System.out.println(JsonUtils.toJson(map));
	}
}
