package com.liquidnet.client.admin.web.controller.zhengzai.sweet;

import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.zhengzai.sweet.service.ISweetIntegralActivityPrizeRelationService;
import com.liquidnet.service.sweet.dto.param.admin.SweetIntegralActivityPrizeRelationFormParam;
import com.liquidnet.service.sweet.entity.SweetIntegralActivityPrizeRelation;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * <p>
 * 积分活动表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-20
 */
@Api(tags = "积分活动管理")
@Validated
@Controller
@RequestMapping("/sweet/integralActivityPrizeRelation")
public class SweetIntegralActivityPrizeRelationController extends BaseController {

    @Autowired
    private ISweetIntegralActivityPrizeRelationService activityPrizeRelationService;

    @Log(title = "积分活动奖品内部关联券等添加", businessType = BusinessType.INSERT)
    @RequiresPermissions("sweet:integralActivityPrizeRelation:create")
    @PostMapping("create")
    @ApiOperation(value = "积分活动奖品内部关联券等添加")
    @ResponseBody
    public AjaxResult create(@Valid @RequestBody SweetIntegralActivityPrizeRelationFormParam param) {
        Integer result = activityPrizeRelationService.createForm(param);
        if (result > 0) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }

    @Log(title = "积分活动奖品内部关联券等删除", businessType = BusinessType.UPDATE)
    @RequiresPermissions("sweet:integralActivityPrizeRelation:update")
    @PutMapping("delete")
    @ApiOperation(value = "积分活动奖品内部关联券等删除")
    @ResponseBody
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "prizeRelationId", value = "主键id", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "integralActivityId", value = "活动主键id", required = true),
    })
    public AjaxResult delete(@RequestParam() String prizeRelationId, @RequestParam() String integralActivityId) {
        Integer result = activityPrizeRelationService.delete(prizeRelationId, integralActivityId);
        if (result > 0) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }

    @Log(title = "积分活动奖品内部关联券等列表", businessType = BusinessType.LIST)
    @RequiresPermissions("sweet:integralActivityPrizeRelation:list")
    @GetMapping("list")
    @ApiOperation(value = "积分活动奖品内部关联券等列表")
    @ResponseBody
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "prizeId", value = "奖品主键id", required = true)
    })
    public List<SweetIntegralActivityPrizeRelation> list(@RequestParam() String prizeId) {
        List<SweetIntegralActivityPrizeRelation> result = activityPrizeRelationService.list(prizeId);
        return result;
    }

}
