package com.liquidnet.commons.lang.util;

import org.apache.commons.lang3.StringUtils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public class IDGenerator {
    private static final String CROSS_BAR = "-";
    private static final String EMPTY_STR = "";
    private static final DateTimeFormatter MILLISECOND = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
    private static final DateTimeFormatter MILLISECOND_2 = DateTimeFormatter.ofPattern("yyDHHmmssSSS");

    public static String nextSnowId() {
        return GenSnowFlowerUtil.next();
    }

    public static String nextTimeId() {
        String s = String.valueOf(System.nanoTime());
        return nextMilliId().concat(s.substring(s.length() - 7));
    }

    public static String nextTimeId2() {
        String s = String.valueOf(System.nanoTime());
        return nextMilliId2().concat(s.substring(s.length() - 7));
    }

    public static String nextMilliId() {
        return LocalDateTime.now().format(MILLISECOND);
    }

    public static String nextMilliId2() {
        return LocalDateTime.now().format(MILLISECOND_2);
    }

    public static String get32UUID() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        return (new UUID(random.nextLong(), random.nextLong())).toString().replace(CROSS_BAR, EMPTY_STR);
    }

    /**
     * 根据订单id生成订单号
     *
     * @param orderTicketId
     * @return
     */
    public static String ticketOrderCode(String orderTicketId) {
        String number = orderTicketId;
        int len = orderTicketId.length();
        String time = System.currentTimeMillis() / 1000 + "";
        String orderCode = number.substring(0, len - 4);
        orderCode += time.substring(7, 8);
        orderCode += number.substring(len - 2);
        orderCode += time.substring(8, 9);
        orderCode += number.substring(len - 4, len - 2);
        return orderCode;
    }

    /**
     * 根据订单id生成总订单号
     *
     * @param orderId
     * @return
     */
    public static String storeCode(String orderId) {
        return ticketOrderCode(orderId);
    }

    public static String storeRefundCode(String orderMasterCode) {
        return orderMasterCode.concat("R").concat(RandomUtil.getRandomInt(0, 99) + "");
    }

    public static String getWriteOffCode() {
        LocalDateTime now = LocalDateTime.now();
        String year = (now.getYear()+"").substring(2);
        String day = now.getDayOfYear()+"";
        String hour = now.getHour()+"";
        String sec = now.getSecond()+"";
        String random = RandomUtil.getRandomInt(0,100)+"";
        if(day.length()==1){
            day="0"+day;
        }
        if(hour.length()==1){
            hour="0"+hour;
        }
        if(sec.length()==1){
            sec="0"+sec;
        }
        String code = year+day+hour+sec+random;
        return StringUtil.switchPosition(StringUtil.switchPosition(code,1,4),3,6);
    }

    /**
     * 根据订单id生成总订单号
     *
     * @return
     */
    public static String storeMasterCode() {
        return nextSnowId();
    }

    public static Long getDamaiCode(String code) {
        if (code.length() < 13) {
            return Long.valueOf(code);
        } else {
            return Long.valueOf(StringUtils.left(code, 5).concat(StringUtils.right(code, 8)));
        }
    }

    public static String payCode() {
        return "PAY" + nextTimeId();
    }

    public static String getZxlNftImageCosCode() {
        return "ZXLNFTIMAGE" + nextTimeId();
    }

    public static String getXuperNftImageCosCode() {
        return "XUPERNFTIMAGE" + nextTimeId();
    }

    public static String refundCode() {
        return "RED" + nextTimeId();
    }

    public static String getSeriesCode() {
        return "SN" + nextTimeId();
    }

    /**
     * 根据 订单号生成qrCode
     *
     * @param orderTicketId
     * @return String
     */
    public static String ticketQrCode(String orderTicketId) {
        String qrCode = MD5Utils.md5(orderTicketId).toLowerCase();
        return "QR" + qrCode.substring(5) + "" + qrCode.substring(0, 4);
    }

    /**
     * 获得活动 spu sku
     *
     * @param marketId
     * @return
     */
    public static String marketGoodId(String marketId) {
        return StringUtil.right(marketId, 5);
    }

    public static void main(String[] args) {
        System.out.println(getWriteOffCode());
    }

    /**
     * 获取兑换码
     * @param num 次数
     * @param sec 单次巡管
     * @param bol 是否添加特殊字符
     * @return
     */
    public static String createCode(int num,int sec,boolean bol) {
        StringBuffer str = new StringBuffer();
        for (int k=0;k<num;k++) {
            for(int i=0;i < sec;i++){
                int intVal=(int)(Math.random()*58+65);
                if(intVal >= 91 && intVal <= 122){
                    i--;
                }
                if(intVal < 91 || intVal > 122){
                    if(intVal%2==0){
                        str.append((char)intVal);
                    }else{
                        str.append((int)(Math.random()*10));
                    }
                }
            }
            if(bol){
                str.append("-");
            }
        }
        return str.toString()+"CH";
    }

}
