package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyUserBindStatusQueryRespDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/18 12:06
 */
@ApiModel(value = "GalaxyUserBindStatusQueryRespDto", description = "用户绑定状态查询")
@Data
public class GalaxyUserBindStatusQueryRespDto  implements Serializable,Cloneable {
    @ApiModelProperty(position = 3, required = true, value = "用户区块链地址")
    private String blockChainAddress;


    @ApiModelProperty(position = 3, required = true, value = "0:绑定中 1:已绑定 2:绑定失败 3:未发起过绑定(未查询到)")
    private Integer userBindStatus;

    @Override
    public String toString() {
        return JsonUtils.toJson(this);
    }

    private static final GalaxyUserBindStatusQueryRespDto obj = new GalaxyUserBindStatusQueryRespDto();

    public static GalaxyUserBindStatusQueryRespDto getNew() {
        try {
            return (GalaxyUserBindStatusQueryRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyUserBindStatusQueryRespDto();
        }
    }
}
