package com.liquidnet.service.candy.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 券码信息
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class CandyCouponCode implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 券码
     */
    private String ccode;

    /**
     * ~candy_coupon.coupon_id
     */
    private String couponId;

    /**
     * 状态[0-可用|1-已用|2-无效|3-过期｜4-失效｜5-退回]
     */
    private Integer state;
    
    /**
     * ~candy_user_coupon.ucoupon_id
     */
    private String ucouponId;

    /**
     * 兑换用户UID
     */
    private String redeemUid;

    /**
     * 兑换用户手机号
     */
    private String redeemMobile;

    /**
     * 兑换时间
     */
    private LocalDateTime redeemAt;

    /**
     * 兑换开放时间
     */
    private LocalDateTime redeemStart;

    /**
     * 兑换停止时间
     */
    private LocalDateTime redeemStop;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;


}
