package com.liquidnet.service.consumer.service;

import java.util.LinkedList;

public interface IBaseDao {
    /**
     * 批量执行sql
     *
     * @param sql
     * @param values
     * @return
     */
    Boolean batchSql(String sql, LinkedList<Object[]> values);

    /**
     * 批量执行不定量sql
     *
     * @param sql
     * @param values
     * @return
     */
    Boolean batchSqls(LinkedList<String> sql, LinkedList<Object[]>... values);

    /**
     * xs 新增一条记录且返回主键Id
     *
     * @param sql   新增待执行sql
     * @param param 参数
     * @return 主键ID
     */
    int insertSqlAndReturnKeyId(final String sql, final Object[] param);
}
