package com.liquidnet.client.admin.zhengzai.admin.service.impl.utils;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.PutObjectRequest;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.FilesUtils;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.dto.vo.basicServices.UploadVo;
import com.liquidnet.service.kylin.entity.PlatformOssFiles;
import com.liquidnet.service.kylin.mapper.PlatformOssFilesMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.File;
import java.time.LocalDateTime;
import java.util.UUID;

/**
 * <p>
 * 临时上传
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-20 2:09 下午
 */
@Component
public class UploadUtil {
    @Value("${liquidnet.aliyun.oss.endpoint}")
    private String endpoint;
    @Value("${liquidnet.aliyun.oss.accessKeyId}")
    private String accessKeyId;
    @Value("${liquidnet.aliyun.oss.accessKeySecret}")
    private String accessKeySecret;

    @Autowired
    private PlatformOssFilesMapper platformOssFilesMapper;

    public UploadVo upload(File file, String pathName, String contentType) {
        OSS ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);

        File fileNew = file;

        // file md5
        String fileMD5 = FilesUtils.getFileMD5(fileNew);
        PlatformOssFiles platformOssFiles = platformOssFilesMapper.selectOne(Wrappers.lambdaQuery(PlatformOssFiles.class).eq(PlatformOssFiles::getMd5str, fileMD5));
        UploadVo uploadVo = new UploadVo();
        if (null == platformOssFiles) {
            String filename = fileNew.getName();
            //这里文件名用了uuid 防止重复，可以根据自己的需要来写
            String uploadName = UUID.randomUUID() + filename.substring(filename.lastIndexOf("."));// 078a77e0-cf80-481b-824c-5935247cff15.jpeg
            uploadName = uploadName.replace("-", "");// 078a77e0cf80481b824c5935247cff15.jpeg
            String uploadpath = pathName + "/" + DateUtil.format(LocalDateTime.now(), DateUtil.Formatter.yyyy_MM_dd2) + "/" + uploadName;
            String buckName = "img-zhengzai-tv";
            PutObjectRequest putObjectRequest = new PutObjectRequest(buckName, uploadpath, fileNew);
            ossClient.putObject(putObjectRequest);
            ossClient.shutdown();

            // 入库
            PlatformOssFiles platformOssFilesDate = new PlatformOssFiles();
            String ossFilesId = IDGenerator.nextSnowId();
            platformOssFilesDate.setOssFilesId(ossFilesId);
            platformOssFilesDate.setOssPath(uploadpath);
            platformOssFilesDate.setFileName(filename);
            platformOssFilesDate.setContentType(contentType);
            platformOssFilesDate.setSize((int) fileNew.length());
            platformOssFilesDate.setMd5str(fileMD5);
            platformOssFilesDate.setBuckType(1);
            platformOssFilesDate.setCreatedAt(DateUtil.getNowTime());
            platformOssFilesMapper.insert(platformOssFilesDate);

            BeanUtils.copyProperties(platformOssFilesDate, uploadVo);
        } else {
            BeanUtils.copyProperties(platformOssFiles, uploadVo);
        }
        return uploadVo;
    }
}
