package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.service.goblin.dto.GoblinGoodsSpecDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "GoblinGoodsSkuInfoDetailVo", description = "商品SKU信息，详情")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinGoodsSkuInfoDetailVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 7139250447538358198L;

    @ApiModelProperty(position = 24, value = "购买限制[0-全部用户|1-仅会员|2-指定用户]")
    private String buyFactor;
    @ApiModelProperty(position = 40, value = "单品规格信息")
    private List<GoblinGoodsSpecDto> skuSpecList;
    @ApiModelProperty(position = 22, value = "单品会员价格[20,2]")
    private BigDecimal priceMember;
    @ApiModelProperty(position = 10, value = "商品单品ID")
    private String skuId;
    @ApiModelProperty(position = 15, value = "单品默认图片的URL[256]")
    private String skuPic;
    @ApiModelProperty(position = 21, value = "单品现价[20,2]")
    private BigDecimal price;
    @ApiModelProperty(position = 33, value = "自定义展示[0-默认展示|1-隐藏不可购买]")
    private String skuAppear;

    private static final GoblinGoodsSkuInfoDetailVo obj = new GoblinGoodsSkuInfoDetailVo();

    public static GoblinGoodsSkuInfoDetailVo getNew() {
        try {
            return (GoblinGoodsSkuInfoDetailVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinGoodsSkuInfoDetailVo();
        }
    }
}
