package com.liquidnet.service.goblin.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 商品券信息
 * </p>
 *
 * @author liquidnet
 * @since 2024-01-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinGoodsSkuCoupon implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 单品id
     */
    private String skuId;

    /**
     * 是否实名[0-否｜1-是，表示该券需要实名使用]
     */
    private Integer isTrueName;

    /**
     * 业务类别[1-演出]
     */
    private Integer busiType;

    /**
     * 券类型[1-代金券]
     */
    private Integer couType;

    /**
     * 适用范围[101-音乐节｜102-小型演出（livehouse演出）｜103-巡演]
     */
    private Integer useScope;

    /**
     * 面值
     */
    private BigDecimal valFace;

    /**
     * 购买后（单位天）有效期，与生效/过期时间二选一
     */
    private Integer validity;

    /**
     * 生效时间
     */
    private LocalDateTime effectAt;

    /**
     * 过期时间
     */
    private LocalDateTime expireAt;

    private String comment;


}
