package com.liquidnet.service.sweet.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel
public class SweetCityVoteStatDto implements Serializable ,Cloneable{

    private static final long serialVersionUID = -3159959399631688127L;

    @ApiModelProperty("城市代码")
    private String cityCode;

    @ApiModelProperty("城市名称")
    private String cityName;

    @ApiModelProperty("真实投票数量")
    private Integer voteNum;

    @ApiModelProperty("手动增加投票数量")
    private Integer manualVoteNum;

    @ApiModelProperty("总投票数")
    private Integer totalNum;


    private static final SweetCityVoteStatDto obj = new SweetCityVoteStatDto();
    public static SweetCityVoteStatDto getNew() {
        try {
            return (SweetCityVoteStatDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetCityVoteStatDto();
        }
    }
}
