package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "AdamCollectionVo", description = "收获地址")
@Data
public class AdamCollectionVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = -7983529662634429915L;
    @ApiModelProperty(position = 10, value = "用户ID[64]")
    private String uid;
    @ApiModelProperty(position = 11, value = "内容ID[64]")
    private String contentId;
    @ApiModelProperty(position = 12, value = "内容标题[255]")
    private String contentTitle;
    @ApiModelProperty(position = 13, value = "内容快照[255]")
    private String contentImg;
    @ApiModelProperty(position = 14, value = "持续时间,单位S,VIDEO类型时存在[30]")
    private Long duration;
    @ApiModelProperty(position = 15, value = "内容类型[VIDEO,TICKET,SITE,ARTIST,BAND,BRAND,STYLE,GOODS,MUSIC,SONG]")
    private String type;
    @ApiModelProperty(position = 16, value = "1-正常,2-删除")
    private Integer state;
    @ApiModelProperty(position = 17, value = "收藏时间[yyyy-MM-dd HH:mm:ss]")
    private String createdAt;
    @ApiModelProperty(position = 18, value = "更新时间[yyyy-MM-dd HH:mm:ss]")
    private String updatedAt;
    @ApiModelProperty(position = 19, value = "备注")
    private String comment;

    private static final AdamCollectionVo obj = new AdamCollectionVo();

    public static AdamCollectionVo getNew() {
        try {
            return (AdamCollectionVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamCollectionVo();
    }
}
