package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@ApiModel(value = "GoblinStoreConfigVo", description = "店铺配置信息")
@Data
public class GoblinStoreConfigVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 6234859594302504118L;
    /**
     * 店铺id
     */
    private String storeId;
    /**
     * 参数名称
     */
    private String configName;
    @ApiModelProperty(position = 12, value = "参数键名")
    private String configKey;
    @ApiModelProperty(position = 13, value = "参数键值")
    private String configVal;
    /**
     * 参数描述
     */
    private String configDesc;
    /**
     * 保留字段
     */
    private String configType;

    private String createdBy;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    private String updatedBy;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;

    public GoblinStoreConfigVo setConfigKey(String configKey) {
        this.configKey = configKey;
        return this;
    }

    public GoblinStoreConfigVo setConfigVal(String configVal) {
        this.configVal = configVal;
        return this;
    }

    private static final GoblinStoreConfigVo obj = new GoblinStoreConfigVo();

    public static GoblinStoreConfigVo getNew() {
        try {
            return (GoblinStoreConfigVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreConfigVo();
        }
    }
}
