package com.liquidnet.service.adam.service;

import lombok.SneakyThrows;

import java.sql.*;

public abstract class DataMigrationProcessorService {
    public Connection connection = null;
    public PreparedStatement statement = null;
    public ResultSet resultSet = null;

    public void handler(boolean flg) {
        preHandler();

        try {
            dataProcessing(flg);
        } catch (Exception e) {
            e.printStackTrace();
        }

        postHandler();
    }

    @SneakyThrows
    private void preHandler() {
        Class.forName("com.mysql.cj.jdbc.Driver");
        connection = DriverManager.getConnection(
                "jdbc:mysql://zhengzai.mysql.polardb.rds.aliyuncs.com:3306/passport",
                "readonly", "ZWDsf8Fy");
    }

    protected abstract void dataProcessing(boolean flg);

    private void postHandler() {
        try {
            assert resultSet != null;
            resultSet.close();
            statement.close();
            connection.close();
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        }
    }
}
