package com.liquidnet.service.adam.controller.admin;

import com.liquidnet.service.adam.service.processor.DMUserInformationProcessor;
import com.liquidnet.service.base.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;

@Api(tags = "DM")
@Slf4j
@Validated
@RestController
@RequestMapping("dm")
public class AdamDMAdminController {
    @Autowired
    DMUserInformationProcessor dmUserInformationProcessor;

    @ApiOperation(value = "user")
    @GetMapping(value = {"user"})
    public ResponseDto<Object> dataMigrationForUser(@RequestParam int alis, @RequestParam boolean flg) {
        if (verify(alis)) dmUserInformationProcessor.handler(flg);
        return ResponseDto.success();
    }

    @ApiOperation(value = "tpa")
    @GetMapping(value = {"tpa"})
    public ResponseDto<Object> dataMigrationForTpa(@RequestParam int alis, @RequestParam boolean flg) {
        if (verify(alis)) dmUserInformationProcessor.handler(flg);
        return ResponseDto.success();
    }

    @ApiOperation(value = "real")
    @GetMapping(value = {"real"})
    public ResponseDto<Object> dataMigrationForReal(@RequestParam int alis, @RequestParam boolean flg) {
        if (verify(alis)) dmUserInformationProcessor.handler(flg);
        return ResponseDto.success();
    }

    @ApiOperation(value = "vip")
    @GetMapping(value = {"vip"})
    public ResponseDto<Object> dataMigrationForVip(@RequestParam int alis, @RequestParam boolean flg) {
        if (verify(alis)) dmUserInformationProcessor.handler(flg);
        return ResponseDto.success();
    }

    @ApiOperation(value = "morder")
    @GetMapping(value = {"morder"})
    public ResponseDto<Object> dataMigrationForMOrder(@RequestParam int alis, @RequestParam boolean flg) {
        if (verify(alis)) dmUserInformationProcessor.handler(flg);
        return ResponseDto.success();
    }

    @ApiOperation(value = "enters")
    @GetMapping(value = {"enters"})
    public ResponseDto<Object> dataMigrationForEnters(@RequestParam int alis, @RequestParam boolean flg) {
        if (verify(alis)) dmUserInformationProcessor.handler(flg);
        return ResponseDto.success();
    }

    @ApiOperation(value = "addr")
    @GetMapping(value = {"addr"})
    public ResponseDto<Object> dataMigrationForAddr(@RequestParam int alis, @RequestParam boolean flg) {
        if (verify(alis)) dmUserInformationProcessor.handler(flg);
        return ResponseDto.success();
    }

    private boolean verify(int alis) {
        LocalDateTime now = LocalDateTime.now();
        int hour = now.getHour();
        return alis == Integer.parseInt((hour > 12 ? hour - 12 : hour) + "" + now.getMinute());
    }
}
