package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 电子宣传手册显示内容表
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetManualSortTfc implements Serializable,Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * manual_id
     */
    private String manualId;

    /**
     * 显示哪个，号隔开
     */
    private String showPosition;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SweetManualSortTfc obj = new SweetManualSortTfc();
    public static SweetManualSortTfc getNew() {
        try {
            return (SweetManualSortTfc) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetManualSortTfc();
        }
    }
}
