package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@ApiModel
@Data
public class GoblinOrderLogVo implements Cloneable {
    @ApiModelProperty(value = "订单id")
    private String orderId;
    @ApiModelProperty(value = "订单号")
    private String orderCode;
    @ApiModelProperty(value = "支付单号")
    private String payCode;
    @ApiModelProperty(value = "订单类型[order-普通订单|zhengzai-正在下单]")
    private String orderType;
    @ApiModelProperty(value = " 商铺id")
    private String storeId;
    @ApiModelProperty(value = " spuId")
    private String spuId;
    @ApiModelProperty(value = " spu名称")
    private String spuName;
    @ApiModelProperty(value = " skuId")
    private String skuId;
    @ApiModelProperty(value = " sku实付价格[价格分]")
    private Long skuPriceActual;
    @ApiModelProperty(value = " sku实付价格")
    private BigDecimal skuPriceActualBig;
    @ApiModelProperty(value = " 日志类型[11-确认付款|12-修改金额|13-发货|14-取消订单|15-修改物流单号|16-核销虚拟商品订单|21-退款申请|22-退款成功|23-退款拒绝|24-退货申请|25-退货拒绝|26-退货审核通过等待用户填写物流(商家审核通过，等待用户寄回商品)|27-待收货(用户已确认)|28-退货完成|29-退款拒绝]")
    private Integer status;
    @ApiModelProperty(value = " 备注")
    private String remark;
    @ApiModelProperty(value = " 操作人Id")
    private String operationId;
    @ApiModelProperty(value = " 操作人姓名")
    private String operationName;
    @ApiModelProperty(value = " 操作人类型[1-用户|2-商家]")
    private Integer operationType;
    @ApiModelProperty(value = " 创建时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;

    public BigDecimal getSkuPriceActualBig() {
        long a = getSkuPriceActual();
        if (a != 0) {
            return new BigDecimal(a / 100);
        } else {
            return skuPriceActualBig;
        }
    }

    private static final GoblinOrderLogVo obj = new GoblinOrderLogVo();

    public static GoblinOrderLogVo getNew() {
        try {
            return (GoblinOrderLogVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinOrderLogVo();
        }
    }
}
