package com.liquidnet.service.kylin.dto.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 购票须知搜索参数
 *
 * @author system
 * @since 2026-01-19
 */
@Data
@ApiModel("购票须知搜索参数")
public class BuyNoticeSearchParam {

    @ApiModelProperty(value = "须知标题")
    private String title;

    @ApiModelProperty(value = "须知类型 1购票须知 2观演须知")
    private Integer noticeType;

    @ApiModelProperty(value = "状态 0禁用 1启用")
    private Integer status;

    @ApiModelProperty(value = "页码")
    private Integer pageNum = 1;

    @ApiModelProperty(value = "每页数量")
    private Integer pageSize = 10;
}