package com.liquidnet.service.slime.service;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.slime.constant.SlimeRedisConst;
import com.liquidnet.service.slime.dto.vo.*;
import com.liquidnet.service.slime.util.ObjectUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Slf4j
@Service
public class SlimeRdmService {

    @Autowired
    RedisUtil redisUtil;

    @Autowired
    private SlimeMongoService slimeMongoService;

    // 【场地】获取详情
    public SlimeFieldsVo getFieldsVoByFieldId(String fieldId) {
        if (null == fieldId || fieldId.isEmpty()) {
            return null;
        }
        String key = SlimeRedisConst.INFO_FIELD.concat(fieldId);
        long s = System.currentTimeMillis();
        SlimeFieldsVo vo = (SlimeFieldsVo) redisUtil.get(key);
        log.debug("#RDM耗时:{}ms", System.currentTimeMillis() - s);
        if (null == vo) {
            vo = slimeMongoService.getFieldsVoByFieldId(fieldId);
            redisUtil.set(key, vo);
        }
        return vo;
    }

    // 【场地】更新详情
    public boolean setFieldsVoByFieldId(String fieldId, SlimeFieldsVo vo) {
        return redisUtil.set(SlimeRedisConst.INFO_FIELD.concat(fieldId), vo);
    }


    // 【场地申请】我的列表
    public List<SlimeFieldAppliesVo> getFieldAppliesVosByUid(String uid) {
        if (null == uid || uid.isEmpty()) {
            return null;
        }
        String key = SlimeRedisConst.INFO_FIELD_APPLIES.concat(uid);
        long s = System.currentTimeMillis();
        List<SlimeFieldAppliesVo> vos = (List<SlimeFieldAppliesVo>) redisUtil.get(key);
        log.debug("#RDM耗时:{}ms", System.currentTimeMillis() - s);
        if (null == vos) {
            vos = slimeMongoService.getFieldAppliesVosByUid(uid);
            redisUtil.set(key, vos);
        }
        return vos;
    }

    // 【场地申请】新增
    public boolean addFieldAppliesVoByUid(String uid, List<SlimeFieldAppliesVo> vos, SlimeFieldAppliesVo vo) {
        if (null == vos) {
            vos = ObjectUtil.getSlimeFieldAppliesVoArrayList();
        }
        vos.add(vo);
        return redisUtil.set(SlimeRedisConst.INFO_FIELD_APPLIES.concat(uid), vos);
    }

    // 【场地申请】删除
    public boolean delFieldAppliesVoByUid(String uid, List<SlimeFieldAppliesVo> vos, SlimeFieldAppliesVo vo) {
        if (CollectionUtils.isEmpty(vos)) {
            return true;
        }
        vos.removeIf(r -> r.getFieldApplyId().equals(vo.getFieldApplyId()));
        return redisUtil.set(SlimeRedisConst.INFO_FIELD_APPLIES.concat(uid), vos);
    }


    // 【场地默认验票员】列表
    public List<SlimeFieldCheckersVo> getFieldCheckersVosByFieldId(String fieldId) {
        String key = SlimeRedisConst.INFO_FIELD_CHECKERS.concat(fieldId);
        long s = System.currentTimeMillis();
        List<SlimeFieldCheckersVo> vos = (List<SlimeFieldCheckersVo>)redisUtil.get(key);
        log.debug("#RDM耗时:{}ms", System.currentTimeMillis() - s);
        if (null == vos) {
            vos = slimeMongoService.getFieldCheckersVosByFieldId(fieldId);
            redisUtil.set(key, vos);
        }
        return vos;
    }

    // 【场地默认验票员】新增
    public boolean addFieldCheckersVoByFieldId(String fieldId, List<SlimeFieldCheckersVo> vos, SlimeFieldCheckersVo vo) {
        if (null == vos) {
            vos = ObjectUtil.getSlimeFieldCheckersVoArrayList();
        }
        vos.add(vo);
        return redisUtil.set(SlimeRedisConst.INFO_FIELD_CHECKERS.concat(fieldId), vos);
    }

    // 【场地默认验票员】删除
    public boolean delFieldCheckersVoByFieldId(String fieldId, List<SlimeFieldCheckersVo> vos, SlimeFieldCheckersVo vo) {
        if (CollectionUtils.isEmpty(vos)) {
            return true;
        }
        vos.removeIf(r -> r.getFieldCheckerId().equals(vo.getFieldCheckerId()));
        return redisUtil.set(SlimeRedisConst.INFO_FIELD_CHECKERS.concat(fieldId), vos);
    }


    // 【主办】详情
    public SlimeSponsorsVo getSponsorsVoBySponsorId(String sponsorId) {
        if (null == sponsorId || sponsorId.isEmpty()) {
            return null;
        }
        String key = SlimeRedisConst.INFO_SPONSOR.concat(sponsorId);
        long s = System.currentTimeMillis();
        SlimeSponsorsVo vo = (SlimeSponsorsVo) redisUtil.get(key);
        log.debug("#RDM耗时:{}ms", System.currentTimeMillis() - s);
        if (null == vo) {
            vo = slimeMongoService.getSponsorsVoBySponsorId(sponsorId);
            redisUtil.set(key, vo);
        }
        return vo;
    }

    // 【主办】更新详情
    public boolean setSponsorsVoBySponsorId(String sponsorId, SlimeSponsorsVo vo) {
        return redisUtil.set(SlimeRedisConst.INFO_SPONSOR.concat(sponsorId), vo);
    }


    // 【主办申请】我的列表
    public List<SlimeSponsorAppliesVo> getSponsorAppliesVosByUid(String uid) {
        if (null == uid || uid.isEmpty()) {
            return null;
        }
        String key = SlimeRedisConst.INFO_SPONSOR_APPLIES.concat(uid);
        long s = System.currentTimeMillis();
        List<SlimeSponsorAppliesVo> vos = (List<SlimeSponsorAppliesVo>) redisUtil.get(key);
        log.debug("#RDM耗时:{}ms", System.currentTimeMillis() - s);
        if (null == vos) {
            vos = slimeMongoService.getSponsorAppliesVosByUid(uid);
            redisUtil.set(key, vos);
        }
        return vos;
    }

    // 【主办申请】新增
    public boolean addSponsorAppliesVoByUid(String uid, List<SlimeSponsorAppliesVo> vos, SlimeSponsorAppliesVo vo) {
        if (null == vos) {
            vos = ObjectUtil.getSlimeSponsorAppliesVoArrayList();
        }
        vos.add(vo);
        return redisUtil.set(SlimeRedisConst.INFO_SPONSOR_APPLIES.concat(uid), vos);
    }

    // 【主办申请】删除
    public boolean delSponsorAppliesVoByUid(String uid, List<SlimeSponsorAppliesVo> vos, SlimeSponsorAppliesVo vo) {
        if (CollectionUtils.isEmpty(vos)) {
            return true;
        }
        vos.removeIf(r -> r.getSponsorApplyId().equals(vo.getSponsorApplyId()));
        return redisUtil.set(SlimeRedisConst.INFO_SPONSOR_APPLIES.concat(uid), vos);
    }
}
