package com.liquidnet.service.goblin.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 首页导航栏

 * </p>
 *
 * @author liquidnet
 * @since 2021-12-28
 */
@Data
@ApiModel(value = "GoblinFrontHotWordBuildParam", description = "首页导航栏")
public class GoblinFrontNavigationBuildParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @ApiModelProperty(value = "主键")
    private Long mid;

    /**
     * 图片路径或id
     */
    @ApiModelProperty(value = "图片路径或id")
    private String picUrl;

    /**
     * 标题
     */
    @ApiModelProperty(value = "标题")
    private String title;

    /**
     * 商品id
     */
    @ApiModelProperty(value = "商品id")
    private String spuId;

    /**
     * 展示形式：1、一行2、二行
     */
    @ApiModelProperty(value = "1、一行2、二行")
    private Integer displayType;

    /**
     * 分类
     */
    @ApiModelProperty(value = "分类")
    private String categoryType;

    /**
     * 活动链接
     */
    @ApiModelProperty(value = "活动链接")
    private String activityUrl;

    /**
     * 1、分类2、专题3、商品单品
     */
    @ApiModelProperty(value = "1、分类2、专题3、商品单品")
    private Integer navigationType;

    /**
     * 顺序
     */
    @ApiModelProperty(value = "顺序")
    private Integer indexs;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间")
    private LocalDateTime updateTime;

    /**
     * 导航id
     */
    @ApiModelProperty(value = "导航id")
    private String navigationId;

    /**
     * 0未删除1已删除
     */
    @ApiModelProperty(value = "0未删除1已删除")
    private Integer delTag;

    /**
     * 商品名字
     */
    @ApiModelProperty(value = "商品名字")
    private String spuName;


}
