package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 购物车vo
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinShoppingCartVoDetail implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long mid;

    /**
     * 购物车id
     */
    @ApiModelProperty(value = "购物车id")
    private String carId;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 商铺id
     */
    @ApiModelProperty(value = "商铺id")
    private String storeId;

    /**
     * 商品id
     */
    @ApiModelProperty(value = "商品id")
    private String spuId;

    /**
     * 款式id
     */
    @ApiModelProperty(value = "款式id")
    private String skuId;

    /**
     * 数量
     */
    @ApiModelProperty(value = "数量")
    private Integer number;

    /**
     * 默认的营销id[活动id]
     */
    private String marketingId;

    /**
     * 删除标记[0-未删除|1-已删除]
     */
    @ApiModelProperty(value = "删除标记[0-未删除|1-已删除]")
    private Integer delTag;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;
    /***
     * sku
     */
    @ApiModelProperty(value = "sku信息")
    private  GoblinGoodsSkuShopCartInfoVo goblinGoodsSkuShopCartInfoVo;

    @ApiModelProperty(value = "spu信息")
    private GoblinGoodsInfoShopCartVo goblinGoodsInfoShopCartVo;
    private static final GoblinShoppingCartVoDetail obj = new GoblinShoppingCartVoDetail();
    public static GoblinShoppingCartVoDetail getNew() {
        try {
            return (GoblinShoppingCartVoDetail) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinShoppingCartVoDetail();
        }
    }

}
