package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.constant.LnsEnum;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetArtists;
import com.liquidnet.service.sweet.entity.SweetPerformanceShow;
import com.liquidnet.service.sweet.mapper.SweetPerformanceMapper;
import com.liquidnet.service.sweet.service.ISweetPerformanceService;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

@Service
public class SweetPerformanceServiceImpl extends ServiceImpl<SweetPerformanceMapper, SweetPerformanceShow> implements ISweetPerformanceService {

   /* @Value("${liquidnet.service.goblin.url}")
    private String goblinUrl;*/
    @Autowired
    private SweetPerformanceMapper sweetPerformanceMapper;
    @Autowired
    private RedisDataUtils redisUtils;
    @Autowired
    private MongoTemplate mongoTemplate;
 /*   @Autowired
    private FeignGoblinArClient feignGoblinArClient;*/
    @Autowired
    Environment environment;

    @Override
    public ResponseDto<Boolean> add(String performanceId,String performanceName,String picOne, String picTwo, String arUrl, String timeStart, String timeEnd) {
        try {
            String offlineUrl=""; //离线地址
           // ResponseDto<Boolean> arData = feignGoblinArClient.getArData(performanceId, "");
//        LocalDateTime time = LocalDateTime.now();
        /*MultiValueMap<String, String> params = new LinkedMultiValueMap();
        params.add("performanceId",mid);
        params.add("tag",null);
        String returnData = HttpUtil.post(goblinUrl.concat("/goblin/inner/ar/data"), params);*/
            String property = environment.getProperty(CurrentUtil.CK_ENV_ACTIVE);
            if (LnsEnum.ENV.dev.name().contains(environment.getProperty(CurrentUtil.CK_ENV_ACTIVE))){
                offlineUrl="devgoblin.zhengzai.tv/goblin/inner/ar/data";
            }else if (LnsEnum.ENV.test.name().contains(environment.getProperty(CurrentUtil.CK_ENV_ACTIVE))){
                offlineUrl="testgoblin.zhengzai.tv/goblin/inner/ar/data";
            }else {
                offlineUrl="prodgoblin.zhengzai.tv/goblin/inner/ar/data";
            }
            SweetPerformanceShow show = SweetPerformanceShow.getNew();

            show.setPerformanceId(performanceId);
            show.setPicOne(picOne);
            show.setPicTwo(picTwo);
            show.setArUrl(arUrl);
            show.setOfflineUrl(offlineUrl);
            show.setTimeStart(timeStart);
            show.setTimeEnd(timeEnd);
            //redis
            redisUtils.setPerformanceAR(performanceId,show);
            //新增 mongo数据
            mongoTemplate.insert(show, SweetPerformanceShow.class.getSimpleName());
            //mysql
            sweetPerformanceMapper.insert(show);
            return ResponseDto.success();
        }catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> change(SweetPerformanceShow show) {
        try {
            String performanceId = show.getPerformanceId();

            //修改redis
            redisUtils.setPerformanceAR(performanceId,show);
            //修改 mongo数据
            Query query = Query.query(Criteria.where("performanceId").is(performanceId));
            Update update = Update.fromDocument(Document.parse(JsonUtils.toJson(show)));
            mongoTemplate.updateFirst(query, update,SweetPerformanceShow.class,SweetPerformanceShow.class.getSimpleName());
            //修改mysql
            sweetPerformanceMapper.update(show,Wrappers.lambdaUpdate(SweetPerformanceShow.class).eq(SweetPerformanceShow::getPerformanceId, performanceId));
            return ResponseDto.success();
        }catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> del(String performanceId) {
        //删除
        redisUtils.delPerformanceARById(performanceId);
        mongoTemplate.remove(Query.query(Criteria.where("performanceId").is(performanceId)),SweetPerformanceShow.class.getSimpleName());
        sweetPerformanceMapper.delete(Wrappers.lambdaQuery(SweetPerformanceShow.class).eq(SweetPerformanceShow::getPerformanceId, performanceId));
        return ResponseDto.success();
    }

    //ar列表
    @Override
    public ResponseDto<PageInfo<SweetPerformanceShow>> getList(Integer page, Integer size, String pid) {
        PageInfo<SweetPerformanceShow> pageInfo = null;
        try {
            List<SweetPerformanceShow> data;
            PageHelper.startPage(page, size);
            if(pid!=null){
                data = sweetPerformanceMapper.selectList(Wrappers.lambdaQuery(SweetPerformanceShow.class).like(SweetPerformanceShow::getPerformanceId, pid));
            }else {
                data = sweetPerformanceMapper.selectList(Wrappers.lambdaQuery(SweetPerformanceShow.class));
            }
            pageInfo = new PageInfo(data);
            return ResponseDto.success(pageInfo);
        }catch (Exception e) {
            return ResponseDto.success(pageInfo);
        }
    }

    @Override
    public ResponseDto<PageInfo<SweetPerformanceShow>> getlistInTime(Integer page, Integer size) {

        return null;
    }


}
