package com.liquidnet.service.goblin.dto.vo;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author TT
 */

@ApiModel(value = "NoticeGoblinMixDetailsVo", description = "票务")
@Data
public class NoticeGoblinMixDetailsVo implements Serializable, Cloneable {
    @ApiModelProperty(value = "活动id")
    private String mixId;
    @ApiModelProperty(value = "用户id")
    private String userId;
    @ApiModelProperty(value = "活动名称")
    private String name;
    @ApiModelProperty(value = "开始时间")
    private String timeStart;
    @ApiModelProperty(value = "结束时间")
    private String timeEnd;
    @ApiModelProperty(value = "展示位置[1-商城|2-数字藏品]")
    private Integer showPosition;
    @ApiModelProperty(value = "组合名称")
    private String sellName;
    @ApiModelProperty(value = "封面图片地址")
    private String coverPic;
    @ApiModelProperty(value = "展示文件类型[1-图片|2-视频]")
    private Integer watchType;
    @ApiModelProperty(value = "销售价格")
    private BigDecimal sellPrice;
    @ApiModelProperty(value = "原价")
    private BigDecimal price;
    @ApiModelProperty(value = "配置详情")
    private List<NoticeGoblinMixDetailsItemVo> item;

    private static final NoticeGoblinMixDetailsVo obj = new NoticeGoblinMixDetailsVo();

    public static NoticeGoblinMixDetailsVo getNew() {
        try {
            return (NoticeGoblinMixDetailsVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new NoticeGoblinMixDetailsVo();
        }
    }

    public NoticeGoblinMixDetailsVo copy(GoblinMixDetailsVo goblinMixDetailsVo) {
        if (null == goblinMixDetailsVo) return getNew();
        this.coverPic = goblinMixDetailsVo.getCoverPic();
        this.item = goblinMixDetailsVo.getItem().stream().map(goblinMixDetailsItemVo -> {
            return NoticeGoblinMixDetailsItemVo.getNew().copy(goblinMixDetailsItemVo);
        }).collect(Collectors.toList());
        this.price = goblinMixDetailsVo.getPrice();
        this.mixId = goblinMixDetailsVo.getMixId();
        this.timeEnd = goblinMixDetailsVo.getTimeEnd();
        this.name = goblinMixDetailsVo.getName();
        this.sellName = goblinMixDetailsVo.getSellName();
        this.sellPrice = goblinMixDetailsVo.getSellPrice();
        this.showPosition = goblinMixDetailsVo.getShowPosition();
        this.timeStart = goblinMixDetailsVo.getTimeStart();
        this.userId = goblinMixDetailsVo.getUserId();
        this.watchType = goblinMixDetailsVo.getWatchType();
        return this;
    }

}
