package com.liquidnet.service.merchant.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.merchant.dto.param.MerchantAuthorizationRecordParam;
import com.liquidnet.service.merchant.dto.vo.MerchantAuthorizationPerformanceVo;
import com.liquidnet.service.merchant.dto.vo.MerchantAuthorizationRecordsVo;
import com.liquidnet.service.merchant.service.IMerchantAuthorizationRecordsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * <p>
 * 授权 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-11-18
 */
@ApiSupport(order = 10003)
@Api(tags = "授权")
@Slf4j
@Validated
@RestController
@RequestMapping("authorizations")
public class MerchantAuthorizationsController {

    @Autowired
    IMerchantAuthorizationRecordsService authorizationRecordsService;

    @ApiOperationSupport(order = 10)
    @ApiOperation(value = "演出下全部权限")
    @GetMapping("info")
    public ResponseDto<MerchantAuthorizationPerformanceVo> authorizationInfo(@RequestParam(required = true) String performanceId) {
        String currentUid = CurrentUtil.getCurrentUid();

        return ResponseDto.success(authorizationRecordsService.performanceAuthorization(currentUid, performanceId));
    }

    @ApiOperationSupport(order = 20)
    @ApiOperation(value = "授权记录列表")
    @GetMapping("records")
    public ResponseDto<List<MerchantAuthorizationRecordsVo>> recordsCheckers(@RequestParam(required = true) String performanceId) {
        String currentUid = CurrentUtil.getCurrentUid();

        return ResponseDto.success(authorizationRecordsService.performanceRecordCheckers(currentUid, performanceId));
    }

    @ApiOperationSupport(order = 21)
    @ApiOperation(value = "添加授权记录")
    @PostMapping("records/add")
    public ResponseDto<Object> recordsCheckerAdd(@Valid @RequestBody MerchantAuthorizationRecordParam parameter) {
        String currentUid = CurrentUtil.getCurrentUid();

        return ResponseDto.success(authorizationRecordsService.performanceRecordCheckerAdd(currentUid, parameter));
    }

    @ApiOperationSupport(order = 22)
    @ApiOperation(value = "删除授权记录")
    @PostMapping("records/del")
    public ResponseDto<Object> recordsCheckerDel(@RequestParam(required = true) String authorizationRecordId) {
        String currentUid = CurrentUtil.getCurrentUid();

        authorizationRecordsService.performanceRecordCheckerDel(currentUid, authorizationRecordId);

        return ResponseDto.success();
    }
}
