package com.liquidnet.service.merchant.util;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.kylin.dao.PerformancePartnerListDao;
import com.liquidnet.service.kylin.dto.param.PerformancePartnerListParam;
import com.liquidnet.service.kylin.dto.param.PerformancePartnerVo;
import com.liquidnet.service.kylin.dto.vo.KylinTimePerformanceVo;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketTimesVo;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketPartnerVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketTimesPartnerVo;
import com.liquidnet.service.merchant.constant.MerchantAuthorizationConst;
import com.liquidnet.service.merchant.dto.vo.MerchantAuthorizationPerformanceVo;
import com.liquidnet.service.merchant.dto.vo.MerchantFieldAppliesVo;
import com.liquidnet.service.merchant.service.MerchantRdmService;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

@Component
public class MongoMerchantUtils {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoConverter mongoConverter;
    @Autowired
    private RedisMerchantUtils redisMerchantUtils;
    @Autowired
    private MerchantRdmService merchantRdmService;


    public PerformancePartnerVo getPerformancePartnerVo(String performanceId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(performanceId)), PerformancePartnerVo.class, PerformancePartnerVo.class.getSimpleName());
    }

    public PerformancePartnerVo getPerformancePartnerVoNoMerchant(String performanceId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(performanceId)), PerformancePartnerVo.class, PerformancePartnerVo.class.getSimpleName());
    }

    public long getPerformancePartnerCount(Query query) {
        return mongoTemplate.count(query, PerformancePartnerVo.class, PerformancePartnerVo.class.getSimpleName());
    }

    public List<PerformancePartnerVo> getPerformancePartnerList(Query query) {
        return mongoTemplate.find(query, PerformancePartnerVo.class, PerformancePartnerVo.class.getSimpleName());
    }

    public PerformancePartnerVo insertPerformancePartnerVo(PerformancePartnerVo data) {
        return mongoTemplate.insert(data, PerformancePartnerVo.class.getSimpleName());
    }

    public KylinTicketTimesPartnerVo insertTicketTimesPartnerVo(KylinTicketTimesPartnerVo data) {
        return mongoTemplate.insert(data, KylinTicketTimesPartnerVo.class.getSimpleName());
    }

    public KylinTicketTimesPartnerVo getTicketTimesPartnerVo(String ticketTimesId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("ticketTimesId").is(ticketTimesId)), KylinTicketTimesPartnerVo.class, KylinTicketTimesPartnerVo.class.getSimpleName());
    }

    public List<KylinTicketTimesPartnerVo> getTicketTimesPartnerVoList(String performancesId) {
        return mongoTemplate.find(Query.query(Criteria.where("performancesId").is(performancesId)), KylinTicketTimesPartnerVo.class, KylinTicketTimesPartnerVo.class.getSimpleName());
    }

    public void updateTicketTimesPartnerVo(KylinTicketTimesPartnerVo data) {
        Query query = Query.query(Criteria.where("ticketTimesId").is(data.getTicketTimesId()));
        BasicDBObject objectTicketVo = ObjectUtil.cloneBasicDBObject().append("$set", mongoConverter.convertToMongoType(data));
        mongoTemplate.getCollection(KylinTicketTimesPartnerVo.class.getSimpleName()).updateOne(
                query.getQueryObject(),
                objectTicketVo
        );
    }

    public Object delTicketTimesPartnerVo(String ticketTimesId) {
        return mongoTemplate.remove(Query.query(Criteria.where("ticketTimesId").is(ticketTimesId)), KylinTicketTimesPartnerVo.class, KylinTicketTimesPartnerVo.class.getSimpleName());
    }

    public KylinTicketPartnerVo insertTicketPartnerVo(KylinTicketPartnerVo data) {
        return mongoTemplate.insert(data, KylinTicketPartnerVo.class.getSimpleName());
    }

    public void updateTicketPartnerVo(KylinTicketPartnerVo data) {
        Query query = Query.query(Criteria.where("ticketsId").is(data.getTicketsId()));
        BasicDBObject objectTicketVo = ObjectUtil.cloneBasicDBObject().append("$set", mongoConverter.convertToMongoType(data));
        mongoTemplate.getCollection(KylinTicketPartnerVo.class.getSimpleName()).updateOne(
                query.getQueryObject(),
                objectTicketVo
        );
    }

    public void submitTicketByTimes(KylinTicketPartnerVo data) {
        Query query = Query.query(Criteria.where("timesId").is(data.getTimesId()).and("status").nin(-2, 7));
        BasicDBObject objectTicketVo = ObjectUtil.cloneBasicDBObject().append("$set", mongoConverter.convertToMongoType(data));
        mongoTemplate.getCollection(KylinTicketPartnerVo.class.getSimpleName()).updateOne(
                query.getQueryObject(),
                objectTicketVo
        );
    }

    public long getCountTicketPartnerByTimes(String timesId) {
        return mongoTemplate.count((Query.query(Criteria.where("timesId").is(timesId))), KylinTicketPartnerVo.class, KylinTicketPartnerVo.class.getSimpleName());
    }

    public List<KylinTicketPartnerVo> getTicketMongoList(String timesId) {
        return mongoTemplate.find(Query.query(Criteria.where("timesId").is(timesId).and("status").ne(-1))
                        .with(Sort.by(Sort.Direction.ASC, "createdAt")),
                KylinTicketPartnerVo.class, KylinTicketPartnerVo.class.getSimpleName());
    }

    public KylinTicketPartnerVo getTicketsMongo(String ticketsId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("ticketsId").is(ticketsId)), KylinTicketPartnerVo.class, KylinTicketPartnerVo.class.getSimpleName());
    }

    public KylinTicketPartnerVo getTicketPartnerVo(String ticketsId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("ticketsId").is(ticketsId)), KylinTicketPartnerVo.class, KylinTicketPartnerVo.class.getSimpleName());
    }

    public List<KylinTicketPartnerVo> getTicketPartnerVoList(String timesId) {
        return mongoTemplate.find(Query.query(Criteria.where("timesId").is(timesId)), KylinTicketPartnerVo.class, KylinTicketPartnerVo.class.getSimpleName());
    }

    public void updatePerformancePartnerVoById(PerformancePartnerVo data) {
        Query query = Query.query(Criteria.where("performancesId").is(data.getPerformancesId()));
        BasicDBObject objectTicketVo = ObjectUtil.cloneBasicDBObject().append("$set", mongoConverter.convertToMongoType(data));
        mongoTemplate.getCollection(PerformancePartnerVo.class.getSimpleName()).updateOne(
                query.getQueryObject(),
                objectTicketVo
        );
    }

    public void updateKylinPerformanceVoById(KylinPerformanceVo data) {
        Query query = Query.query(Criteria.where("performancesId").is(data.getPerformancesId()));
        BasicDBObject objectTicketVo = ObjectUtil.cloneBasicDBObject().append("$set", mongoConverter.convertToMongoType(data));
        mongoTemplate.getCollection(KylinPerformanceVo.class.getSimpleName()).updateOne(
                query.getQueryObject(),
                objectTicketVo
        );
    }

    public void updateSubmitTicketVoById(KylinTicketPartnerVo data) {
        Query query = Query.query(Criteria.where("ticketsId").is(data.getTicketsId()).and("status").in(3, 6, 8, 9, 10));
        BasicDBObject objectTicketVo = ObjectUtil.cloneBasicDBObject().append("$set", mongoConverter.convertToMongoType(data));
        mongoTemplate.getCollection(KylinTicketPartnerVo.class.getSimpleName()).updateOne(
                query.getQueryObject(),
                objectTicketVo
        );
    }

    public void deleteTicketPartnerVo(String ticketsId) {
        mongoTemplate.remove(Query.query(Criteria.where("ticketsId").is(ticketsId)), KylinTicketPartnerVo.class, KylinTicketPartnerVo.class.getSimpleName());
    }

    public boolean isExistsSubmitPerformancePartner(String performanceId) {
        return mongoTemplate.exists(Query.query(Criteria.where("performancesId").is(performanceId).and("auditStatus").is(0)),
                PerformancePartnerVo.class,
                PerformancePartnerVo.class.getSimpleName());
    }

    public boolean isExistsAddTicket(String timesId) {
        return mongoTemplate.exists(Query.query(Criteria.where("status").is(-2).and("timesId").is(timesId)), KylinTicketPartnerVo.class, KylinTicketPartnerVo.class.getSimpleName());
    }

    public boolean isExistsAddTime(String performanceId) {
        return mongoTemplate.exists(Query.query(Criteria.where("status").is(-1).and("performancesId").is(performanceId)), KylinTicketTimesPartnerVo.class, KylinTicketTimesPartnerVo.class.getSimpleName());
    }

    public List<KylinTicketTimesPartnerVo> getTimesMongoList(String performanceId) {
        return mongoTemplate.find(Query.query(Criteria.where("performancesId").is(performanceId)).with(Sort.by(Sort.Direction.ASC, "createdAt")),
                KylinTicketTimesPartnerVo.class, KylinTicketTimesPartnerVo.class.getSimpleName());
    }

    public KylinTicketTimesPartnerVo getTimesMongo(String timesId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("ticketTimesId").is(timesId).and("status")), KylinTicketTimesPartnerVo.class, KylinTicketTimesPartnerVo.class.getSimpleName());
    }

    public KylinPerformanceVo insertPerformanceVo(KylinPerformanceVo data) {
        return mongoTemplate.insert(data, KylinPerformanceVo.class.getSimpleName());
    }

    public Object delPerformanceVo(String performanceId) {
        redisMerchantUtils.delPerformanceVo(performanceId);
        return mongoTemplate.remove(Query.query(Criteria.where("performancesId").is(performanceId)), KylinPerformanceVo.class, KylinPerformanceVo.class.getSimpleName());
    }

    public KylinPerformanceVo getPerformanceVo(String performanceId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(performanceId)), KylinPerformanceVo.class, KylinPerformanceVo.class.getSimpleName());
    }

    public KylinPerformanceVo getPerformanceVoNoMerchant(String performanceId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(performanceId)), KylinPerformanceVo.class, KylinPerformanceVo.class.getSimpleName());
    }

    public List<KylinPerformanceVo> getPerformanceVoOnlineList() {
        return mongoTemplate.find(Query.query(Criteria.where("appStatus").in(6, 8, 9)), KylinPerformanceVo.class, KylinPerformanceVo.class.getSimpleName());
    }

    //新增 演唱定时任务
    public KylinTimePerformanceVo insertTimeLine(KylinTimePerformanceVo data) {
        return mongoTemplate.insert(data, KylinTimePerformanceVo.class.getSimpleName());
    }

    //获取 演唱定时任务
    public List<KylinTimePerformanceVo> getTimeLine(String performanceId) {
        return mongoTemplate.find(Query.query(Criteria.where("performanceId").is(performanceId)), KylinTimePerformanceVo.class, KylinTimePerformanceVo.class.getSimpleName());
    }

    //删除 演出定时任务
    public Object delTimeLine(String performances) {
        return mongoTemplate.remove(Query.query(Criteria.where("performanceId").is(performances)), KylinTimePerformanceVo.class, KylinTimePerformanceVo.class.getSimpleName());
    }

    /**
     * 判断该用户对于此演出是否有权限
     *
     * @param performanceId 演出id
     * @param merchantId    用户id(第三方id)
     * @param permissionIds 权限id
     * @return
     */
    public boolean judgeIsPermission(String performanceId, String merchantId, String[] permissionIds) {
        if (redisMerchantUtils.superAccount(merchantId)) {
            return true;
        } else {
            return mongoTemplate.exists(Query.query(Criteria.where("performanceId").is(performanceId)
                            .and("uid").is(merchantId)
                            .and("permissionIds").in(permissionIds))
                    , MerchantAuthorizationPerformanceVo.class, MerchantAuthorizationPerformanceVo.class.getSimpleName());
        }
    }

    public Document getObjectTicketVo(HashMap<String, Object> map, String ticketsId) {
        BasicDBObject objectTicketVo = ObjectUtil.cloneBasicDBObject().append("$set", mongoConverter.convertToMongoType(map));
        Document docTicket = mongoTemplate.getCollection(KylinTicketPartnerVo.class.getSimpleName()).findOneAndUpdate(
                Query.query(Criteria.where("ticketsId").is(ticketsId)).getQueryObject(),
                objectTicketVo,
                new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
        );
        return docTicket;
    }

    public List<PerformancePartnerListDao> getPerformanceList(PerformancePartnerListParam performancePartnerListParam) {
        performancePartnerListParam.setOrderType(performancePartnerListParam.getOrderType());
        //分页排序
        Sort.Direction orderBy = Sort.Direction.DESC;
        if (performancePartnerListParam.getOrderSc().equals("asc")) {
            orderBy = Sort.Direction.ASC;
        }

        List<String> performanceIdList = null;
        List<MerchantAuthorizationPerformanceVo> permissionVoList = ObjectUtil.getPermissionVoList();
        if (!redisMerchantUtils.superAccount(performancePartnerListParam.getMerchantId())) {
            //根据权限查询演出id
            permissionVoList = mongoTemplate.find(Query.query(Criteria.where("uid").is(performancePartnerListParam.getMerchantId())
                            .and("permissionIds").in(
                            MerchantAuthorizationConst.PerformancePermission.READ.getId(),
                            MerchantAuthorizationConst.PerformancePermission.SALES.getId(),
                            MerchantAuthorizationConst.PerformancePermission.LINE.getId())
                    )
                            .skip(((performancePartnerListParam.getPage() - 1) * performancePartnerListParam.getSize()))
                            .limit(performancePartnerListParam.getSize()),
                    MerchantAuthorizationPerformanceVo.class, MerchantAuthorizationPerformanceVo.class.getSimpleName());
            performanceIdList = permissionVoList.stream().map(MerchantAuthorizationPerformanceVo::getPerformanceId).collect(Collectors.toList());
        }
        //查询演出
        Criteria criteria = performanceIdList == null ? Criteria.where("performancesId").ne(null) : Criteria.where("performancesId").in(performanceIdList);
        if (performancePartnerListParam.getTitle() != null && !performancePartnerListParam.getTitle().isEmpty()) {
            criteria = criteria.and("title").regex(".*" + performancePartnerListParam.getTitle() + ".*");
        }
        if (performancePartnerListParam.getStatus() != null) {
            if (performancePartnerListParam.getStatus() == 0) {
                criteria = criteria.and("appStatus").is(0);
            } else {
                if (performancePartnerListParam.getStatus() != -2) {
                    criteria = criteria.and("appStatus").is(performancePartnerListParam.getStatus());
                }
                if (performancePartnerListParam.getTimeStart() != null && !performancePartnerListParam.getTimeStart().isEmpty()) {
                    criteria = criteria.and("timeStart").gte(performancePartnerListParam.getTimeStart()).and("timeStart").lte(performancePartnerListParam.getTimeEnd());
                }
            }
        }
        List<KylinPerformanceVo> performanceVos = mongoTemplate.find(
                Query.query(new Criteria().orOperator(criteria,Criteria.where("merchantId").is(performancePartnerListParam.getMerchantId()))).with(Sort.by(orderBy, performancePartnerListParam.getOrderItem())),
//                Query.query(criteria.orOperator(Criteria.where("merchantId").is(performancePartnerListParam.getMerchantId()))).with(Sort.by(orderBy, performancePartnerListParam.getOrderItem())),
                KylinPerformanceVo.class, KylinPerformanceVo.class.getSimpleName());
        //查询销量
        Aggregation aggregation = Aggregation.newAggregation(
                Aggregation.match(Criteria.where("status").in(0, 1, 3, 6).and("couponType").is("no").and("transferStatus").in(0, 1, 2, 5).and("performanceId").in(performanceIdList)),
                Aggregation.group("performanceId")
                        .first("performanceId").as("performancesId")
                        .sum("number").as("number")
                        .sum("refundNumber").as("refundNumber")
                        .sum("priceActual").as("priceActual")
                        .sum("priceRefund").as("priceRefund")

        );
        AggregationResults<PerformancePartnerListDao> outputType = mongoTemplate.aggregate(aggregation, KylinOrderTicketVo.class.getSimpleName(), PerformancePartnerListDao.class);
        List<PerformancePartnerListDao> dataList = new ArrayList(outputType.getMappedResults());
        List<PerformancePartnerListDao> list = ObjectUtil.getPerformancePartnerListDaoArrayList();
        for (KylinPerformanceVo item : performanceVos) {
            boolean findData = false;
            PerformancePartnerListDao dao = PerformancePartnerListDao.getNew();
            dao.setPerformancesId(item.getPerformancesId());
            dao.setTitle(item.getTitle());
            dao.setTimeStart(item.getTimeStart());
            dao.setTimeEnd(item.getTimeEnd());
            dao.setStatus(item.getAppStatus());
            dao.setType(item.getType());
            dao.setPayCountdownMinute(item.getPayCountdownMinute());
            dao.setAuditStatus(item.getAuditStatus());
            dao.setRejectTxt(item.getRejectTxt());
            dao.setCreatedAt(item.getCreatedAt());
            int totalGeneral = 0;
            String timeSell = null;
            String timeStop = null;
            for (KylinTicketTimesVo timeItem : item.getTicketTimeList()) {
                for (KylinTicketVo ticketItem : timeItem.getTicketList()) {
                    if (timeSell == null) {
                        timeSell = ticketItem.getTimeStart();
                    } else if (DateUtil.compareStrDay(timeSell, ticketItem.getTimeStart()) > 0) {
                        timeSell = ticketItem.getTimeStart();
                    }
                    if (timeStop == null) {
                        timeStop = ticketItem.getTimeEnd();
                    } else if (DateUtil.compareStrDay(timeStop, ticketItem.getTimeEnd()) < 0) {
                        timeStop = ticketItem.getTimeEnd();
                    }
                    totalGeneral += ticketItem.getTotalGeneral();
                }
            }
            dao.setTotalGeneral(totalGeneral);
            dao.setTimeSell(timeSell);
            dao.setTimeStop(timeStop);

            for (MerchantAuthorizationPerformanceVo permission : permissionVoList) {
                if (permission.getPerformanceId().equals(item.getPerformancesId())) {
                    dao.setPermissionId(permission.getPermissionIds());
                    permissionVoList.remove(permission);
                    break;
                }
            }

            for (int i = 0; i < dataList.size(); i++) {
                PerformancePartnerListDao data = dataList.get(i);
                if (data.getPerformancesId().equals(item.getPerformancesId())) {
                    findData = true;
                    dao.setNumber(data.getNumber());
                    dao.setRefundNumber(data.getRefundNumber());
                    dao.setPriceActual(data.getPriceActual());
                    dao.setPriceRefund(data.getPriceRefund());
                    dataList.remove(i);
                    break;
                }
            }

            if (!findData) {
                dao.setNumber(0);
                dao.setRefundNumber(0);
                dao.setPriceActual(BigDecimal.ZERO);
                dao.setPriceRefund(BigDecimal.ZERO);
            }
            list.add(dao);
        }

        return list;
    }

    public List<PerformancePartnerListDao> getPerformanceListField(PerformancePartnerListParam performancePartnerListParam) {
        //分页排序
        Sort.Direction orderBy = Sort.Direction.DESC;
        if (performancePartnerListParam.getOrderSc().equals("asc")) {
            orderBy = Sort.Direction.ASC;
        }
        //根据用户id获取场地拥有那些演出
        List<String> fieldsIdList = merchantRdmService.getFieldAppliesVosByUid(performancePartnerListParam.getMerchantId()).stream().map(MerchantFieldAppliesVo::getFieldId).collect(Collectors.toList());
        //查询演出
        Criteria criteria = fieldsIdList == null ? Criteria.where("fieldId").ne(null) : Criteria.where("fieldId").in(fieldsIdList);
        if (performancePartnerListParam.getTitle() != null && !performancePartnerListParam.getTitle().isEmpty()) {
            criteria = criteria.and("title").regex(".*" + performancePartnerListParam.getTitle() + ".*");
        }
        if (performancePartnerListParam.getTimeStart() != null && !performancePartnerListParam.getTimeStart().isEmpty()) {
            criteria = criteria.and("timeStart").gte(performancePartnerListParam.getTimeStart()).and("timeStart").lte(performancePartnerListParam.getTimeEnd());
        }
        List<KylinPerformanceVo> performanceVos = mongoTemplate.find(
                Query.query(criteria.and("fieldAuditStatus").is(1)).with(Sort.by(orderBy, performancePartnerListParam.getOrderItem())),
                KylinPerformanceVo.class, KylinPerformanceVo.class.getSimpleName());
        //查询销量
        Aggregation aggregation = Aggregation.newAggregation(
                Aggregation.match(Criteria.where("status").in(0, 1, 3, 6).and("couponType").is("no").and("transferStatus").in(0, 1, 2, 5).and("performanceId").in(performanceVos.stream().map(KylinPerformanceVo::getPerformancesId).collect(Collectors.toList()))),
                Aggregation.group("performanceId")
                        .first("performanceId").as("performancesId")
                        .sum("number").as("number")
                        .sum("refundNumber").as("refundNumber")
                        .sum("priceActual").as("priceActual")
                        .sum("priceRefund").as("priceRefund")
        );
        AggregationResults<PerformancePartnerListDao> outputType = mongoTemplate.aggregate(aggregation, KylinOrderTicketVo.class.getSimpleName(), PerformancePartnerListDao.class);
        List<PerformancePartnerListDao> dataList = new ArrayList(outputType.getMappedResults());
        List<PerformancePartnerListDao> list = ObjectUtil.getPerformancePartnerListDaoArrayList();
        for (KylinPerformanceVo item : performanceVos) {
            boolean findData = false;
            PerformancePartnerListDao dao = PerformancePartnerListDao.getNew();
            dao.setPerformancesId(item.getPerformancesId());
            dao.setTitle(item.getTitle());
            dao.setTimeStart(item.getTimeStart());
            dao.setTimeEnd(item.getTimeEnd());
            dao.setStatus(item.getAppStatus());
            dao.setType(item.getType());
            dao.setPayCountdownMinute(item.getPayCountdownMinute());
            dao.setAuditStatus(item.getAuditStatus());
            dao.setRejectTxt(item.getRejectTxt());
            dao.setCreatedAt(item.getCreatedAt());
            int totalGeneral = 0;
            String timeSell = null;
            String timeStop = null;
            for (KylinTicketTimesVo timeItem : item.getTicketTimeList()) {
                for (KylinTicketVo ticketItem : timeItem.getTicketList()) {
                    if (timeSell == null) {
                        timeSell = ticketItem.getTimeStart();
                    } else if (DateUtil.compareStrDay(timeSell, ticketItem.getTimeStart()) > 0) {
                        timeSell = ticketItem.getTimeStart();
                    }
                    if (timeStop == null) {
                        timeStop = ticketItem.getTimeEnd();
                    } else if (DateUtil.compareStrDay(timeStop, ticketItem.getTimeEnd()) < 0) {
                        timeStop = ticketItem.getTimeEnd();
                    }
                    totalGeneral += ticketItem.getTotalGeneral();
                }
            }
            dao.setTotalGeneral(totalGeneral);
            dao.setTimeSell(timeSell);
            dao.setTimeStop(timeStop);

            for (int i = 0; i < dataList.size(); i++) {
                PerformancePartnerListDao data = dataList.get(i);
                if (data.getPerformancesId().equals(item.getPerformancesId())) {
                    findData = true;
                    dao.setNumber(data.getNumber());
                    dao.setRefundNumber(data.getRefundNumber());
                    dao.setPriceActual(data.getPriceActual());
                    dao.setPriceRefund(data.getPriceRefund());
                    dataList.remove(i);
                    break;
                }
            }

            if (!findData) {
                dao.setNumber(0);
                dao.setRefundNumber(0);
                dao.setPriceActual(BigDecimal.ZERO);
                dao.setPriceRefund(BigDecimal.ZERO);
            }
            list.add(dao);
        }

        return list;
    }
}
