package com.liquidnet.service.adam.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 用户会员订单扩展信息表
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamMemberOrderExt implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    private String orderNo;

    /**
     * 快递状态:0-待揽收|1-已揽收|2-在途中|3-已签收｜4-已拒收
     */
    private Integer expressStatus;

    /**
     * 收件人
     */
    private String expressReceiver;

    /**
     * 收件人电话
     */
    private String expressPhone;

    /**
     * 收件人地址
     */
    private String expressAddress;

    private String comment;


}
