package com.liquidnet.service.consumer.candy.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.candy.receiver.ConsumerCandyCouponUseRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.util.ArrayList;
import java.util.List;

import static com.liquidnet.service.base.constant.MQConst.CandyQueue.COUPON_USE;

@Configuration
public class ConsumerCandyCouponUseRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerCandyCouponUseRdsReceiver consumerCandyCouponUseRdsReceiver;
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Bean
    public List<Subscription> subscriptionCouponUse(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.CandyQueue stream = MQConst.CandyQueue.COUPON_USE;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 3; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerCandyCouponUseRdsReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

//    /**
//     * 缺票登记
//     *
//     * @param listenerContainer
//     * @param t
//     * @return
//     */
//    private Subscription receiveSqlCandyCouponUse(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
//        return listenerContainer.receiveAutoAck(Consumer.from(COUPON_USE.getGroup(), getConsumerName(COUPON_USE.name() + t)),
//                StreamOffset.create(COUPON_USE.getKey(), ReadOffset.lastConsumed()), consumerCandyCouponUseRdsReceiver
//        );
//    }
//
//    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */
//
//    /* -------------------------------------------------------- ｜ 缺票登记 */
//
//    @Bean
//    public Subscription subscriptionSqlCandyCouponUse0(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlCandyCouponUse(listenerContainer, 0);
//        listenerContainer.start();
//        return subscription;
//    }
//
//    @Bean
//    public Subscription subscriptionSqlCandyCouponUse1(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlCandyCouponUse(listenerContainer, 1);
//        listenerContainer.start();
//        return subscription;
//    }
//
//    @Bean
//    public Subscription subscriptionSqlCandyCouponUse2(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlCandyCouponUse(listenerContainer, 2);
//        listenerContainer.start();
//        return subscription;
//    }
//
//    /* -------------------------------------------------------- ｜  */
}
