package com.liquidnet.service.consumer.slowly.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.slowly.receiver.ConsumerKylinSqlPerformanceLackRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.util.ArrayList;
import java.util.List;

import static com.liquidnet.service.base.constant.MQConst.KylinQueue.SQL_PERFORMANCE_LACK;

@Configuration
public class ConsumerKylinSqlPerformanceLackRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerKylinSqlPerformanceLackRdsReceiver consumerKylinSqlPerformanceLackRdsReceiver;
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Bean
    public List<Subscription> subscriptionSqlPLack(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.KylinQueue stream = SQL_PERFORMANCE_LACK;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 1; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerKylinSqlPerformanceLackRdsReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

//    /**
//     * 缺票登记
//     *
//     * @param listenerContainer
//     * @param t
//     * @return
//     */
//    private Subscription receiveSqlPerformanceLack(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
//        return listenerContainer.receiveAutoAck(Consumer.from(SQL_PERFORMANCE_LACK.getGroup(), getConsumerName(SQL_PERFORMANCE_LACK.name() + t)),
//                StreamOffset.create(SQL_PERFORMANCE_LACK.getKey(), ReadOffset.lastConsumed()), consumerKylinSqlPerformanceLackRdsReceiver);
//    }
//
//    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */
//
//    /* -------------------------------------------------------- ｜ 缺票登记 */
//
//    @Bean
//    public Subscription subscriptionSqlPerformanceLack0(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlPerformanceLack(listenerContainer, 0);
//        listenerContainer.start();
//        return subscription;
//    }

    /* -------------------------------------------------------- ｜  */
}
