package com.liquidnet.service.goblin.service.impl;

import com.liquidnet.service.goblin.constant.GoblinStatusConst;
import com.liquidnet.service.goblin.dto.vo.GoblinMarketRelationVo;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfMarketingVo;
import com.liquidnet.service.goblin.dto.vo.GoblinShowStoreInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo;
import com.liquidnet.service.goblin.service.IGoblinAppZhengzaiService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import com.liquidnet.service.goblin.util.QueueUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

import static com.liquidnet.commons.lang.util.DateUtil.DTF_YMD_HMS;

@Service
public class GoblinAppZhengzaiServiceImpl implements IGoblinAppZhengzaiService {

    @Autowired
    GoblinRedisUtils redisUtils;
    @Autowired
    GoblinMongoUtils mongoUtils;
    @Autowired
    QueueUtils queueUtils;


    @Override
    public List<GoblinSelfMarketingVo> getZhengzaiMarketList() {
        List<GoblinSelfMarketingVo> list = redisUtils.getGoblinSelfMarketingVoList();
        List<GoblinSelfMarketingVo> voList = ObjectUtil.getGoblinSelfMarketingVoList();
        LocalDateTime now = LocalDateTime.now();
        for (GoblinSelfMarketingVo item : list) {
            if (LocalDateTime.parse(item.getStartTime(), DTF_YMD_HMS).isBefore(now) && LocalDateTime.parse(item.getEndTime(), DTF_YMD_HMS).isAfter(now)) {
                voList.add(item);
            }
        }
        return voList;
    }

    @Override
    public List<GoblinShowStoreInfoVo> getStoreList(String marketId) {
        List<GoblinMarketRelationVo> relationVo = redisUtils.getMarketRelation(GoblinStatusConst.MarketPreStatus.MARKET_PRE_ZHENGZAI.getValue(), marketId);
        List<String> storeIdList = relationVo.stream().map(GoblinMarketRelationVo::getStoreId).collect(Collectors.toList());
        List<GoblinShowStoreInfoVo> voList = ObjectUtil.getGoblinShowStoreInfoVoArrayList();
        for (String storeId : storeIdList) {
            GoblinStoreInfoVo vo = redisUtils.getStoreInfoVo(storeId);
            if (vo.getStatus().equals("5")) {
                GoblinShowStoreInfoVo returnVo = GoblinShowStoreInfoVo.getNew();
                BeanUtils.copyProperties(vo, returnVo);
                voList.add(returnVo);
            }
        }
        return voList;
    }
}
