package com.liquidnet.service.kylin.dto.param;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class PerformanceCreateParam implements Serializable {

    @ApiModelProperty(value = "演出id", example = "")
    @JsonIgnore
    private String performancesId;

    @ApiModelProperty(value = "封面图", example = "https://img.zhengzai.tv/partner/2019/05/14/5cda2d0520177.png")
    private String imgPoster;

    @ApiModelProperty(value = "演出名称", example = "测试演出")
    private String title;

    @ApiModelProperty(value = "演出类型 1音乐节 2演唱会 3小型演出 4展览 6舞台剧", example = "3")
    private int type;

    @ApiModelProperty(value = "演出开始时间", example = "2021-05-01 12:00:00")
    private String timeStart;

    @ApiModelProperty(value = "演出结束时间", example = "2021-05-04 12:00:00")
    private String timeEnd;

    @ApiModelProperty(value = "场地id", example = "1")
    private String fieldId;

    @ApiModelProperty(value = "场地id", example = "1")
    private String fieldName;

    @ApiModelProperty(value = "演出公告", example = "这是演出公告")
    private String notice;

    @ApiModelProperty(value = "主办方id", example = "1")
    private String sponsorId;

    @ApiModelProperty(value = "主办方类型", example = "1")
    private String sponsorType;

    @ApiModelProperty(value = "主办方名称", example = "主办方名称")
    private String sponsor;

    @ApiModelProperty(value = "联系人", example = "联系人")
    private String contacts;

    @ApiModelProperty(value = "联系方式", example = "手机号")
    private String mobile;

    @ApiModelProperty(value = "演出详情", example = "<p>演出详情</p>")
    private String details;

    @ApiModelProperty(value = "演出批文地址", example = "这是一个演出批文地址")
    private String approvalUrl;

    @ApiModelProperty(value = "待支付时间", example = "5")
    private int payCountdownMinute;

    @ApiModelProperty(value = "购票须知", example = "[{\"id\":1,\"title\":\"\\u95e8\\u7968\\u4e0d\\u9000\\u4e0d\\u6362\",\"type\":\"image\",\"url\":\"http:\\/\\/img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com\\/partner\\/2019\\/01\\/21\\/5c45722882a13.png\",\"text\":\"\\u95e8\\u7968\\u4e3a\\u6709\\u4ef7\\u8bc1\\u5238\\uff0c\\u5e76\\u975e\\u5546\\u54c1\\uff0c\\u4e00\\u7ecf\\u552e\\u51fa\\u4e0d\\u4e88\\u9000\\u6362\\u3002\\u56e0\\u201c\\u4e0d\\u53ef\\u6297\\u529b\\u201d\\u5bfc\\u81f4\\u7684\\u6f14\\u51fa\\u53d6\\u6d88\\u6216\\u5ef6\\u671f\\u9664\\u5916\\u3002\",\"sort\":1},{\"id\":3,\"title\":\"\\u4ec5\\u8bbe\\u7ad9\\u5e2d\",\"type\":\"image\",\"url\":\"http:\\/\\/img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com\\/partner\\/2019\\/01\\/21\\/5c456e93db0b9.png\",\"text\":\"\\u672c\\u573a\\u6f14\\u51fa\\u4e0d\\u8bbe\\u5ea7\\u4f4d\\uff0c\\u5747\\u4e3a\\u7ad9\\u5e2d\\u89c2\\u6f14\\u3002\",\"sort\":2},{\"id\":4,\"title\":\"\\u7981\\u6b62\\u4e2a\\u4eba\\u7968\\u52a1\\u4e70\\u5356\",\"type\":\"image\",\"url\":\"http:\\/\\/img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com\\/partner\\/2019\\/01\\/21\\/5c456e5c27644.png\",\"text\":\"\\u4e3a\\u9632\\u6b62\\u4e0d\\u6cd5\\u5206\\u5b50\\u5229\\u7528\\u7968\\u52a1\\u8f6c\\u8ba9\\u8bc8\\u9a97\\u94b1\\u6b3e\\uff0c\\u5efa\\u8bae\\u5e7f\\u5927\\u4e50\\u8ff7\\u4e0d\\u8981\\u8fdb\\u884c\\u4e2a\\u4eba\\u95f4\\u7968\\u52a1\\u4e70\\u5356\\uff0c\\u4e0d\\u8981\\u8f7b\\u6613\\u76f8\\u4fe1\\u6765\\u6e90\\u4e0d\\u660e\\u7684\\u8f6c\\u7968\\uff0c\\u4ee5\\u514d\\u81ea\\u8eab\\u5229\\u76ca\\u53d7\\u5230\\u4fb5\\u5bb3\\u3002\",\"sort\":3}]")
    private String noticeImage;

    @ApiModelProperty(value = "是否实名", example = "0")
    private int isTrueName;

    @ApiModelProperty(value = "限购数量 0为不限购", example = "0")
    private int limitCount;

    @ApiModelProperty(value = "是否提交 1提交 0不提交(不验证参数)", example = "0")
    private int isSubmit;

    @ApiModelProperty(value = "状态:-1删除;0未提交;1审核中;2审核中（自动上线）;3审核通过;4审核未通过;6上线;7下架;8活动结束;9活动取消退款中;10活动取消退", example = "0")
    private int status;

    @ApiModelProperty(value = "第三方id", example = "0")
    private String merchantId;

    @ApiModelProperty(value = "演出简介", example = "0")
    private String describes;

    @ApiModelProperty(value = "", example = "")
    private String createdAt;
}
