package com.liquidnet.service.kylin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * <p>
 * banner返回给前端的数据字段
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-03 11:19 上午
 */

@Data
public class BannersVo implements Serializable {
    @ApiModelProperty(value = "Banner主键ID")
    private String bannersId;

    @ApiModelProperty(value = "标题")
    private String bannersName;

    @ApiModelProperty(value = "封面图")
    private String coverImg;

    @ApiModelProperty(value = "跳转类型")
    private Integer targetType;

    @ApiModelProperty(value = "跳转目标id或者url")
    private String targetObj;

    @ApiModelProperty(value = "是否上线展示 0下线 1上线")
    private Integer isOnline;

    @ApiModelProperty(value = "上线开始时间")
    private String onlineStartTime;

    @ApiModelProperty(value = "上线结束时间")
    private String onlineEndTime;

    @ApiModelProperty(value = "推广类型 1全国 2省份")
    private Integer promotionType;

    @ApiModelProperty(value = "排序权重 越大越靠前")
    private Integer BannersSort;

    @ApiModelProperty(value = "备注")
    private String remarks;

    @ApiModelProperty(value = "是否删除 0已删除,1正常")
    private Integer isDeleted;

    @ApiModelProperty(value = "创建时间")
    private String  createdAt;

    @ApiModelProperty(value = "修改时间")
    private String updatedAt;

}
