package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 演出状态
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinPerformanceStatus implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * performance_status_id
     */
    private String performanceStatusId;

    /**
     * 演出关联id
     */
    private String performanceId;

    /**
     * 是否显示 0全部用户可见 1白名单可见 2任何不显示
     */
    private Integer isShow;

    /**
     * 状态:-1删除;0未提交;1审核中;2审核中（自动上线）;3审核通过;4审核未通过;6上线;7下架;8活动结束;9活动取消退款中;10活动取消退
     */
    private int status;

    /**
     * 是否售卖 0停止 1正常
     */
    private Integer statusSell;

    /**
     * 是否开启分销 0关闭 1开启
     */
    private Integer isDistribution;

    /**
     * 是否关联小程序 0不关联 1关联
     */
    private Integer syncAgent;

    /**
     * -1未提交审核，0提交审核，1审核通过，2审核拒绝
     */
    private Integer auditStatus;

    /**
     * 是否实名 0不需要 1需要
     */
    private  Integer isTrueName;

    /**
     * 限购张数 0无限 (开启实名 则实名限购 未开始为账号限购)
     */
    private Integer limitCount;


    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;


}
