package com.liquidnet.service.bank.currencycloud.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author LiChen
 * @date 2020/9/17 5:27 下午
 */
@Data
@ApiModel(description = "bank cc funding accounts")
public class BankCcFundingAccountsParam {

    @ApiModelProperty(value = "The currency of the account details required. ISO 4217 standard.", required = true)
    private String currency;

    @ApiModelProperty(value = "UUID of a specific account you want to see the SSIs for")
    private String accountId;

    @ApiModelProperty(value = "The type of SSI to be returned e.g. priority (SWIFT) or regular. Defaults to all.", allowableValues = "all,priority,regular", example = "all")
    private String paymentType;

    @ApiModelProperty(value = "Page number.")
    private String page;

    @ApiModelProperty(value = "Number of results per page.")
    private String perPage;

    @ApiModelProperty(value = "Any field name to change the sort order.")
    private String order;

    @ApiModelProperty(value = "Sort records in ascending or descending order.", allowableValues = "asc,desc", example = "asc")
    private String orderAscDesc;

    public BankCcFundingAccountsParam() {
    }

    public BankCcFundingAccountsParam(String currency, String accountId) {
        this.currency = currency;
        this.accountId = accountId;
    }

}
