package com.liquidnet.service.goblin.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.DigestUtils;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;

@ApiModel(value = "GoblinUserSafeConfigDto", description = "NFT:用户安全配置")
@Data
@JsonIgnoreProperties(value = {"uid"}, ignoreUnknown = true)
public class GoblinUserSafeConfigDto implements Serializable, Cloneable {
    private static final long serialVersionUID = -141364364882594556L;
    @ApiModelProperty(position = 11, value = "安全密码")
    private String passwd;

    private static final GoblinUserSafeConfigDto obj = new GoblinUserSafeConfigDto();

    public static GoblinUserSafeConfigDto getNew() {
        return obj.clone();
    }

    @Override
    public GoblinUserSafeConfigDto clone() {
        try {
            return (GoblinUserSafeConfigDto) super.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinUserSafeConfigDto();
        }
    }

    public boolean validPasswd(String saltPasswd) {
        return this.passwd.equals(DigestUtils.md5DigestAsHex(saltPasswd.getBytes(StandardCharsets.UTF_8)));
    }
}
