package com.liquidnet.service.kylin.service.admin;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.kylin.dto.param.BuyNoticeParam;
import com.liquidnet.service.kylin.dto.param.BuyNoticeSearchParam;
import com.liquidnet.service.kylin.dto.vo.BuyNoticeVo;
import com.liquidnet.service.kylin.entity.KylinBuyNotice;

import java.util.List;

/**
 * 购票须知服务接口
 *
 * @author system
 * @since 2026-01-19
 */
public interface IBuyNoticeService {

    /**
     * 创建购票须知
     */
    Boolean create(BuyNoticeParam param);

    /**
     * 更新购票须知
     */
    Boolean update(BuyNoticeParam param);

    /**
     * 获取购票须知详情
     */
    BuyNoticeVo detail(String buyNoticeId);

    /**
     * 删除购票须知
     */
    Boolean delete(List<String> buyNoticeIds);

    /**
     * 购票须知列表
     */
    PageInfo<KylinBuyNotice> noticeList(BuyNoticeSearchParam param);
}