package com.liquidnet.service.galaxy.router.zxin.service;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.router.strategy.IGalaxyRouterStrategyTradeQuery;
import com.liquidnet.service.galaxy.router.strategy.annotation.StrategyGalaxyRouterTradeQueryHandler;
import com.liquidnet.service.galaxy.router.zxin.biz.ZxinTradeQueryBiz;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: PayChannelStrategyAlipayImpl
 * @Package com.liquidnet.service.dragon.channel.strategy.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/4/7 13:06
 */
@Slf4j
@Component
@StrategyGalaxyRouterTradeQueryHandler(GalaxyEnum.RouterTypeEnum.ZXINCHAIN)
public class GalaxyRouterStrategyZxlTradeQueryImpl implements IGalaxyRouterStrategyTradeQuery {
    @Autowired
    private ZxinTradeQueryBiz zxinTradeQueryBiz;

    @Override
    public ResponseDto<GalaxyQueryNftInfoRespDto> queryNftInfo(GalaxyQueryNftInfoReqDto reqDto) {
        return zxinTradeQueryBiz.queryNftInfo(reqDto);
    }

    @Override
    public ResponseDto<GalaxyQueryTransNftInfoRespDto> queryTransNftInfo(GalaxyQueryTransNftInfoReqDto reqDto) {
        return null;
    }

    @Override
    public ResponseDto<GalaxyQueryNftTradeListRespDto> queryNftTradeList(GalaxyQueryNftTradeListReqDto reqDto) {
        return zxinTradeQueryBiz.queryNftTradeList(reqDto);
    }

    @Override
    public ResponseDto<GalaxyQuerySeriesInfoRespDto> querySeriesInfo(GalaxyQuerySeriesInfoReqDto reqDto) {
        return zxinTradeQueryBiz.querySeriesInfo(reqDto);
    }

    @Override
    public ResponseDto<GalaxyQueryUserSeriesNftListRespDto> queryUserSeriesNftList(GalaxyQueryUserSeriesNftListReqDto reqDto) {
        return zxinTradeQueryBiz.queryUserSeriesNftList(reqDto);
    }

    @Override
    public ResponseDto<GalaxyQueryUserTradeAllListRespDto> queryUserTradeAllList(GalaxyQueryUserTradeAllListReqDto reqDto) {
        return zxinTradeQueryBiz.queryUserTradeAllList(reqDto);
    }

    @Override
    public ResponseDto<GalaxyQueryUserTradeInListRespDto> queryUserTradeInList(GalaxyQueryUserTradeInListReqDto reqDto) {
        return zxinTradeQueryBiz.queryUserTradeInList(reqDto);
    }

    @Override
    public ResponseDto<GalaxyQueryUserTradeOutListRespDto> queryUserTradeOutList(GalaxyQueryUserTradeOutListReqDto reqDto) {
        return zxinTradeQueryBiz.queryUserTradeOutList(reqDto);
    }
}
